/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.Hashtable;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;

public class ClassCache {
    private static final Object AKEY = new Object();
    private volatile boolean cachingIsEnabled = true;
    Hashtable classTable = new Hashtable();
    Hashtable javaAdapterGeneratedClasses = new Hashtable();
    ScriptableObject scope;
    private Hashtable interfaceAdapterCache;
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scriptable) {
        ClassCache classCache = (ClassCache)ScriptableObject.getTopScopeValue(scriptable, AKEY);
        if (classCache == null) {
            classCache = new ClassCache();
        }
        return classCache;
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        if (this == scriptableObject.associateValue(AKEY, this)) {
            this.scope = scriptableObject;
            return true;
        }
        return false;
    }

    public synchronized void clearCaches() {
        this.classTable = new Hashtable();
        this.javaAdapterGeneratedClasses = new Hashtable();
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class clazz) {
        Hashtable hashtable = this.interfaceAdapterCache;
        Object var2_3 = hashtable == null ? null : hashtable.get(clazz);
        return var2_3;
    }

    synchronized void cacheInterfaceAdapter(Class clazz, Object object) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                this.interfaceAdapterCache = new Hashtable();
            }
            this.interfaceAdapterCache.put(clazz, object);
        }
    }
}

