/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n2);
            int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            if (n5 > 0) {
                byteBuffer.position(n2 + n5);
            }
            n = n5;
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = l != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, l, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        return IOUtil.write(fileDescriptor, byteBufferArray, 0, byteBufferArray.length, nativeDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, int n, int n2, NativeDispatcher nativeDispatcher) throws IOException {
        long l;
        block18: {
            ByteBuffer byteBuffer;
            int n3;
            int n4;
            boolean bl;
            IOVecWrapper iOVecWrapper;
            block16: {
                long l2;
                block17: {
                    iOVecWrapper = IOVecWrapper.get(n2);
                    bl = false;
                    n4 = 0;
                    int n5 = n + n2;
                    for (int i = n; i < n5; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i];
                        int n6 = byteBuffer2.position();
                        int n7 = byteBuffer2.limit();
                        assert (n6 <= n7);
                        int n8 = n3 = n6 <= n7 ? n7 - n6 : 0;
                        if (n3 <= 0) continue;
                        iOVecWrapper.setBuffer(n4, byteBuffer2, n6, n3);
                        if (!(byteBuffer2 instanceof DirectBuffer)) {
                            byteBuffer = Util.getTemporaryDirectBuffer(n3);
                            byteBuffer.put(byteBuffer2);
                            byteBuffer.flip();
                            iOVecWrapper.setShadow(n4, byteBuffer);
                            byteBuffer2.position(n6);
                            byteBuffer2 = byteBuffer;
                            n6 = byteBuffer.position();
                        }
                        iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer2)).address() + (long)n6);
                        iOVecWrapper.putLen(n4, n3);
                        ++n4;
                    }
                    if (n4 != 0) break block16;
                    l2 = 0L;
                    Object var19_19 = null;
                    if (bl) break block17;
                    for (int i = 0; i < n4; ++i) {
                        ByteBuffer byteBuffer3 = iOVecWrapper.getShadow(i);
                        if (byteBuffer3 != null) {
                            Util.offerLastTemporaryDirectBuffer(byteBuffer3);
                        }
                        iOVecWrapper.clearRefs(i);
                    }
                }
                return l2;
            }
            try {
                long l3;
                long l4 = l3 = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    if (l4 > 0L) {
                        byteBuffer = iOVecWrapper.getBuffer(n3);
                        int n9 = iOVecWrapper.getPosition(n3);
                        int n10 = iOVecWrapper.getRemaining(n3);
                        int n11 = l4 > (long)n10 ? n10 : (int)l4;
                        byteBuffer.position(n9 + n11);
                        l4 -= (long)n11;
                    }
                    if ((byteBuffer = iOVecWrapper.getShadow(n3)) != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
                bl = true;
                l = l3;
                Object var19_20 = null;
                if (bl) break block18;
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                if (!bl) {
                    for (int i = 0; i < n4; ++i) {
                        ByteBuffer byteBuffer4 = iOVecWrapper.getShadow(i);
                        if (byteBuffer4 != null) {
                            Util.offerLastTemporaryDirectBuffer(byteBuffer4);
                        }
                        iOVecWrapper.clearRefs(i);
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < n4; ++i) {
                ByteBuffer byteBuffer5 = iOVecWrapper.getShadow(i);
                if (byteBuffer5 != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer5);
                }
                iOVecWrapper.clearRefs(i);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
        try {
            int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            n = n2;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = l != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, l, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        return IOUtil.read(fileDescriptor, byteBufferArray, 0, byteBufferArray.length, nativeDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, int n, int n2, NativeDispatcher nativeDispatcher) throws IOException {
        long l;
        block21: {
            ByteBuffer byteBuffer;
            int n3;
            int n4;
            boolean bl;
            IOVecWrapper iOVecWrapper;
            block19: {
                long l2;
                block20: {
                    iOVecWrapper = IOVecWrapper.get(n2);
                    bl = false;
                    n4 = 0;
                    int n5 = n + n2;
                    for (int i = n; i < n5; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i];
                        if (byteBuffer2.isReadOnly()) {
                            throw new IllegalArgumentException("Read-only buffer");
                        }
                        int n6 = byteBuffer2.position();
                        int n7 = byteBuffer2.limit();
                        assert (n6 <= n7);
                        int n8 = n3 = n6 <= n7 ? n7 - n6 : 0;
                        if (n3 <= 0) continue;
                        iOVecWrapper.setBuffer(n4, byteBuffer2, n6, n3);
                        if (!(byteBuffer2 instanceof DirectBuffer)) {
                            byteBuffer = Util.getTemporaryDirectBuffer(n3);
                            iOVecWrapper.setShadow(n4, byteBuffer);
                            byteBuffer2 = byteBuffer;
                            n6 = byteBuffer.position();
                        }
                        iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer2)).address() + (long)n6);
                        iOVecWrapper.putLen(n4, n3);
                        ++n4;
                    }
                    if (n4 != 0) break block19;
                    l2 = 0L;
                    Object var20_19 = null;
                    if (bl) break block20;
                    for (int i = 0; i < n4; ++i) {
                        ByteBuffer byteBuffer3 = iOVecWrapper.getShadow(i);
                        if (byteBuffer3 != null) {
                            Util.offerLastTemporaryDirectBuffer(byteBuffer3);
                        }
                        iOVecWrapper.clearRefs(i);
                    }
                }
                return l2;
            }
            try {
                long l3;
                long l4 = l3 = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    byteBuffer = iOVecWrapper.getShadow(n3);
                    if (l4 > 0L) {
                        int n9;
                        ByteBuffer byteBuffer4 = iOVecWrapper.getBuffer(n3);
                        int n10 = iOVecWrapper.getRemaining(n3);
                        int n11 = n9 = l4 > (long)n10 ? n10 : (int)l4;
                        if (byteBuffer == null) {
                            int n12 = iOVecWrapper.getPosition(n3);
                            byteBuffer4.position(n12 + n9);
                        } else {
                            byteBuffer.limit(byteBuffer.position() + n9);
                            byteBuffer4.put(byteBuffer);
                        }
                        l4 -= (long)n9;
                    }
                    if (byteBuffer != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
                bl = true;
                l = l3;
                Object var20_20 = null;
                if (bl) break block21;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (!bl) {
                    for (int i = 0; i < n4; ++i) {
                        ByteBuffer byteBuffer5 = iOVecWrapper.getShadow(i);
                        if (byteBuffer5 != null) {
                            Util.offerLastTemporaryDirectBuffer(byteBuffer5);
                        }
                        iOVecWrapper.clearRefs(i);
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < n4; ++i) {
                ByteBuffer byteBuffer6 = iOVecWrapper.getShadow(i);
                if (byteBuffer6 != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer6);
                }
                iOVecWrapper.clearRefs(i);
            }
        }
        return l;
    }

    static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n);
        return fileDescriptor;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        Util.load();
    }
}

