/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import sun.awt.SunToolkit;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.font.TrueTypeGlyphMapper;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.GetPropertyAction;

public class TrueTypeFont
extends FileFont {
    public static final int cmapTag = 1668112752;
    public static final int glyfTag = 1735162214;
    public static final int headTag = 1751474532;
    public static final int hheaTag = 1751672161;
    public static final int hmtxTag = 1752003704;
    public static final int locaTag = 1819239265;
    public static final int maxpTag = 1835104368;
    public static final int nameTag = 1851878757;
    public static final int postTag = 1886352244;
    public static final int os_2Tag = 1330851634;
    public static final int GDEFTag = 1195656518;
    public static final int GPOSTag = 1196445523;
    public static final int GSUBTag = 1196643650;
    public static final int mortTag = 1836020340;
    public static final int fdscTag = 1717859171;
    public static final int fvarTag = 1719034226;
    public static final int featTag = 1717920116;
    public static final int EBLCTag = 1161972803;
    public static final int gaspTag = 1734439792;
    public static final int ttcfTag = 1953784678;
    public static final int v1ttTag = 65536;
    public static final int trueTag = 1953658213;
    public static final int MS_PLATFORM_ID = 3;
    public static final short ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int FULL_NAME_ID = 4;
    public static final int POSTSCRIPT_NAME_ID = 6;
    TTDisposerRecord disposerRecord = new TTDisposerRecord();
    int fontIndex = 0;
    int directoryCount = 1;
    int directoryOffset;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private boolean supportsJA;
    private boolean supportsCJK;
    private static final int TTCHEADERSIZE = 12;
    private static final int DIRECTORYHEADERSIZE = 12;
    private static final int DIRECTORYENTRYSIZE = 16;
    static final String[] encoding_mapping = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "", "", "", "", "", "", "", "", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361", "", "", "", "", "", "", "", "", "", ""};
    private static final String[][] languages = new String[][]{{"en", "ca", "da", "de", "es", "fi", "fr", "is", "it", "nl", "no", "pt", "sq", "sv"}, {"cs", "cz", "et", "hr", "hu", "nr", "pl", "ro", "sk", "sl", "sq", "sr"}, {"bg", "mk", "ru", "sh", "uk"}, {"el"}, {"tr"}, {"he"}, {"ar"}, {"et", "lt", "lv"}, {"th"}, {"ja"}, {"zh", "zh_CN"}, {"ko"}, {"zh_HK", "zh_TW"}, {"ko"}};
    private static final String[] codePages = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361"};
    private static String defaultCodePage = null;
    public static final int reserved_bits1 = Integer.MIN_VALUE;
    public static final int reserved_bits2 = 65535;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int fsSelectionRegularBit = 64;
    private float stSize;
    private float stPos;
    private float ulSize;
    private float ulPos;
    private int[] bwGlyphs;
    private char[] gaspTable;

    TrueTypeFont(String string, Object object, int n, boolean bl) throws FontFormatException {
        super(string, object);
        this.useJavaRasterizer = bl;
        this.fontRank = 3;
        try {
            this.verify();
            this.init(n);
        }
        catch (Throwable throwable) {
            this.close();
            if (throwable instanceof FontFormatException) {
                throw (FontFormatException)throwable;
            }
            throw new FontFormatException("Unexpected runtime exception.");
        }
        Disposer.addObjectRecord(this, this.disposerRecord);
    }

    protected boolean checkUseNatives() {
        if (this.checkedNatives) {
            return this.useNatives;
        }
        if (!FontManager.isSolaris || this.useJavaRasterizer || FontManager.useT2K || this.nativeNames == null || this.getDirectoryEntry(1161972803) != null || GraphicsEnvironment.isHeadless()) {
            this.checkedNatives = true;
            return false;
        }
        if (this.nativeNames instanceof String) {
            String string = (String)this.nativeNames;
            if (string.indexOf("8859") > 0) {
                this.checkedNatives = true;
                return false;
            }
            if (NativeFont.hasExternalBitmaps(string)) {
                this.nativeFonts = new NativeFont[1];
                try {
                    this.nativeFonts[0] = new NativeFont(string, true);
                    this.useNatives = true;
                }
                catch (FontFormatException fontFormatException) {
                    this.nativeFonts = null;
                }
            }
        } else if (this.nativeNames instanceof String[]) {
            int n;
            String[] stringArray = (String[])this.nativeNames;
            int n2 = stringArray.length;
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].indexOf("8859") > 0) {
                    this.checkedNatives = true;
                    return false;
                }
                if (!NativeFont.hasExternalBitmaps(stringArray[n])) continue;
                bl = true;
            }
            if (!bl) {
                this.checkedNatives = true;
                return false;
            }
            this.useNatives = true;
            this.nativeFonts = new NativeFont[n2];
            for (n = 0; n < n2; ++n) {
                try {
                    this.nativeFonts[n] = new NativeFont(stringArray[n], true);
                    continue;
                }
                catch (FontFormatException fontFormatException) {
                    this.useNatives = false;
                    this.nativeFonts = null;
                }
            }
        }
        if (this.useNatives) {
            this.glyphToCharMap = new char[this.getMapper().getNumGlyphs()];
        }
        this.checkedNatives = true;
        return this.useNatives;
    }

    private synchronized FileChannel open() throws FontFormatException {
        if (this.disposerRecord.channel == null) {
            if (FontManager.logging) {
                FontManager.logger.info("open TTF: " + this.platName);
            }
            try {
                RandomAccessFile randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return new RandomAccessFile(TrueTypeFont.this.platName, "r");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                });
                this.disposerRecord.channel = randomAccessFile.getChannel();
                this.fileSize = (int)this.disposerRecord.channel.size();
                FontManager.addToPool(this);
            }
            catch (NullPointerException nullPointerException) {
                this.close();
                throw new FontFormatException(nullPointerException.toString());
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                this.open();
            }
            catch (IOException iOException) {
                this.close();
                throw new FontFormatException(iOException.toString());
            }
        }
        return this.disposerRecord.channel;
    }

    protected synchronized void close() {
        this.disposerRecord.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBlock(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        block21: {
            n3 = 0;
            try {
                TrueTypeFont trueTypeFont = this;
                synchronized (trueTypeFont) {
                    if (this.disposerRecord.channel == null) {
                        this.open();
                    }
                    if (n + n2 > this.fileSize) {
                        if (n >= this.fileSize) {
                            if (FontManager.logging) {
                                String string = "Read offset is " + n + " file size is " + this.fileSize + " file is " + this.platName;
                                FontManager.logger.severe(string);
                            }
                            return -1;
                        }
                        n2 = this.fileSize - n;
                    }
                    byteBuffer.clear();
                    this.disposerRecord.channel.position(n);
                    while (n3 < n2) {
                        int n4 = this.disposerRecord.channel.read(byteBuffer);
                        if (n4 == -1) {
                            String string = "Unexpected EOF " + this;
                            int n5 = (int)this.disposerRecord.channel.size();
                            if (n5 != this.fileSize) {
                                string = string + " File size was " + this.fileSize + " and now is " + n5;
                            }
                            if (FontManager.logging) {
                                FontManager.logger.severe(string);
                            }
                            if (n3 > n2 / 2 || n3 > 16384) {
                                byteBuffer.flip();
                                if (FontManager.logging) {
                                    string = "Returning " + n3 + " bytes instead of " + n2;
                                    FontManager.logger.severe(string);
                                }
                            } else {
                                n3 = -1;
                            }
                            throw new IOException(string);
                        }
                        n3 += n4;
                    }
                    byteBuffer.flip();
                    if (n3 > n2) {
                        n3 = n2;
                    }
                }
            }
            catch (FontFormatException fontFormatException) {
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, fontFormatException);
                }
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.readBlock(byteBuffer, n, n2);
            }
            catch (IOException iOException) {
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, iOException);
                }
                if (n3 != 0) break block21;
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readBlock(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            TrueTypeFont trueTypeFont = this;
            synchronized (trueTypeFont) {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                if (n + n2 > this.fileSize) {
                    if (n > this.fileSize) {
                        return null;
                    }
                    byteBuffer = ByteBuffer.allocate(this.fileSize - n);
                }
                this.disposerRecord.channel.position(n);
                this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
        }
        catch (FontFormatException fontFormatException) {
            return null;
        }
        catch (ClosedChannelException closedChannelException) {
            Thread.interrupted();
            this.close();
            this.readBlock(byteBuffer, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteBuffer;
    }

    byte[] readBytes(int n, int n2) {
        ByteBuffer byteBuffer = this.readBlock(n, n2);
        if (byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    private void verify() throws FontFormatException {
        this.open();
    }

    protected void init(int n) throws FontFormatException {
        ByteBuffer byteBuffer;
        int n2 = 0;
        ByteBuffer byteBuffer2 = this.readBlock(0, 12);
        try {
            switch (byteBuffer2.getInt()) {
                case 1953784678: {
                    byteBuffer2.getInt();
                    this.directoryCount = byteBuffer2.getInt();
                    if (n >= this.directoryCount) {
                        throw new FontFormatException("Bad collection index");
                    }
                    this.fontIndex = n;
                    byteBuffer2 = this.readBlock(12 + 4 * n, 4);
                    n2 = byteBuffer2.getInt();
                    break;
                }
                case 65536: 
                case 1953658213: {
                    break;
                }
                default: {
                    throw new FontFormatException("Unsupported sfnt " + this.getPublicFileName());
                }
            }
            byteBuffer2 = this.readBlock(n2 + 4, 2);
            this.numTables = byteBuffer2.getShort();
            this.directoryOffset = n2 + 12;
            byteBuffer = this.readBlock(this.directoryOffset, this.numTables * 16);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry directoryEntry;
                this.tableDirectory[i] = directoryEntry = new DirectoryEntry();
                directoryEntry.tag = intBuffer.get();
                intBuffer.get();
                directoryEntry.offset = intBuffer.get();
                directoryEntry.length = intBuffer.get();
                if (directoryEntry.offset + directoryEntry.length <= this.fileSize) continue;
                throw new FontFormatException("bad table, tag=" + directoryEntry.tag);
            }
            this.initNames();
        }
        catch (Exception exception) {
            if (FontManager.logging) {
                FontManager.logger.severe(exception.toString());
            }
            if (exception instanceof FontFormatException) {
                throw (FontFormatException)exception;
            }
            throw new FontFormatException(exception.toString());
        }
        if (this.familyName == null || this.fullName == null) {
            throw new FontFormatException("Font name not found");
        }
        byteBuffer = this.getTableBuffer(1330851634);
        this.setStyle(byteBuffer);
        this.setCJKSupport(byteBuffer);
    }

    static String getCodePage() {
        if (defaultCodePage != null) {
            return defaultCodePage;
        }
        if (FontManager.isWindows) {
            defaultCodePage = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        } else {
            if (languages.length != codePages.length) {
                throw new InternalError("wrong code pages array length");
            }
            Locale locale = SunToolkit.getStartupLocale();
            String string = locale.getLanguage();
            if (string != null) {
                String string2;
                if (string.equals("zh") && (string2 = locale.getCountry()) != null) {
                    string = string + "_" + string2;
                }
                for (int i = 0; i < languages.length; ++i) {
                    for (int j = 0; j < languages[i].length; ++j) {
                        if (!string.equals(languages[i][j])) continue;
                        defaultCodePage = codePages[i];
                        return defaultCodePage;
                    }
                }
            }
        }
        if (defaultCodePage == null) {
            defaultCodePage = "";
        }
        return defaultCodePage;
    }

    boolean supportsEncoding(String string) {
        if (string == null) {
            string = TrueTypeFont.getCodePage();
        }
        if ("".equals(string)) {
            return false;
        }
        if ((string = string.toLowerCase()).equals("gb18030")) {
            string = "gbk";
        } else if (string.equals("ms950_hkscs")) {
            string = "ms950";
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1330851634);
        if (byteBuffer == null || byteBuffer.capacity() < 86) {
            return false;
        }
        int n = byteBuffer.getInt(78);
        int n2 = byteBuffer.getInt(82);
        for (int i = 0; i < encoding_mapping.length; ++i) {
            if (!encoding_mapping[i].equals(string) || (1 << i & n) == 0) continue;
            return true;
        }
        return false;
    }

    private void setCJKSupport(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.capacity() < 50) {
            return;
        }
        int n = byteBuffer.getInt(46);
        this.supportsCJK = (n & 0x29BF0000) != 0;
        this.supportsJA = (n & 0x60000) != 0;
    }

    boolean supportsJA() {
        return this.supportsJA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getTableBuffer(int n) {
        int n2;
        DirectoryEntry directoryEntry = null;
        for (n2 = 0; n2 < this.numTables; ++n2) {
            if (this.tableDirectory[n2].tag != n) continue;
            directoryEntry = this.tableDirectory[n2];
            break;
        }
        if (directoryEntry == null || directoryEntry.length == 0 || directoryEntry.offset + directoryEntry.length > this.fileSize) {
            return null;
        }
        n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(directoryEntry.length);
        TrueTypeFont trueTypeFont = this;
        synchronized (trueTypeFont) {
            try {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                this.disposerRecord.channel.position(directoryEntry.offset);
                n2 = this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.getTableBuffer(n);
            }
            catch (IOException iOException) {
                return null;
            }
            catch (FontFormatException fontFormatException) {
                return null;
            }
            if (n2 < directoryEntry.length) {
                return null;
            }
            return byteBuffer;
        }
    }

    byte[] getTableBytes(int n) {
        ByteBuffer byteBuffer = this.getTableBuffer(n);
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            try {
                return byteBuffer.array();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[this.getTableSize(n)];
        byteBuffer.get(byArray);
        return byArray;
    }

    int getTableSize(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].length;
        }
        return 0;
    }

    int getTableOffset(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].offset;
        }
        return 0;
    }

    DirectoryEntry getDirectoryEntry(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    boolean useEmbeddedBitmapsForSize(int n) {
        if (!this.supportsCJK) {
            return false;
        }
        if (this.getDirectoryEntry(1161972803) == null) {
            return false;
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1161972803);
        int n2 = byteBuffer.getInt(4);
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.get(8 + i * 48 + 45) & 0xFF;
            if (n3 != n) continue;
            return true;
        }
        return false;
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void setStyle() {
        this.setStyle(this.getTableBuffer(1330851634));
    }

    private void setStyle(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.capacity() < 64) {
            super.setStyle();
            return;
        }
        int n = byteBuffer.getChar(62) & 0xFFFF;
        int n2 = n & 1;
        int n3 = n & 0x20;
        int n4 = n & 0x40;
        if (n4 != 0 && (n2 | n3) != 0) {
            super.setStyle();
            return;
        }
        if ((n4 | n2 | n3) == 0) {
            super.setStyle();
            return;
        }
        switch (n3 | n2) {
            case 1: {
                this.style = 2;
                break;
            }
            case 32: {
                if (FontManager.isSolaris && this.platName.endsWith("HG-GothicB.ttf")) {
                    this.style = 0;
                    break;
                }
                this.style = 1;
                break;
            }
            case 33: {
                this.style = 3;
            }
        }
    }

    private void setStrikethroughMetrics(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < 30 || n < 0) {
            this.stSize = 0.05f;
            this.stPos = -0.4f;
            return;
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        this.stSize = (float)shortBuffer.get(13) / (float)n;
        this.stPos = (float)(-shortBuffer.get(14)) / (float)n;
    }

    private void setUnderlineMetrics(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < 12 || n < 0) {
            this.ulSize = 0.05f;
            this.ulPos = 0.1f;
            return;
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        this.ulSize = (float)shortBuffer.get(5) / (float)n;
        this.ulPos = (float)(-shortBuffer.get(4)) / (float)n;
    }

    public void getStyleMetrics(float f, float[] fArray, int n) {
        if (this.ulSize == 0.0f && this.ulPos == 0.0f) {
            Buffer buffer;
            ByteBuffer byteBuffer = this.getTableBuffer(1751474532);
            int n2 = -1;
            if (byteBuffer != null && byteBuffer.capacity() >= 18) {
                buffer = byteBuffer.asShortBuffer();
                n2 = ((ShortBuffer)buffer).get(9) & 0xFFFF;
            }
            buffer = this.getTableBuffer(1330851634);
            this.setStrikethroughMetrics((ByteBuffer)buffer, n2);
            ByteBuffer byteBuffer2 = this.getTableBuffer(1886352244);
            this.setUnderlineMetrics(byteBuffer2, n2);
        }
        fArray[n] = this.stPos * f;
        fArray[n + 1] = this.stSize * f;
        fArray[n + 2] = this.ulPos * f;
        fArray[n + 3] = this.ulSize * f;
    }

    private String makeString(byte[] byArray, int n, short s) {
        Object object;
        if (s >= 2 && s <= 6) {
            object = byArray;
            int n2 = n;
            byArray = new byte[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (object[i] == false) continue;
                byArray[n++] = (byte)object[i];
            }
        }
        switch (s) {
            case 1: {
                object = "UTF-16";
                break;
            }
            case 0: {
                object = "UTF-16";
                break;
            }
            case 2: {
                object = "SJIS";
                break;
            }
            case 3: {
                object = "GBK";
                break;
            }
            case 4: {
                object = "MS950";
                break;
            }
            case 5: {
                object = "EUC_KR";
                break;
            }
            case 6: {
                object = "Johab";
                break;
            }
            default: {
                object = "UTF-16";
            }
        }
        try {
            return new String(byArray, 0, n, (String)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (FontManager.logging) {
                FontManager.logger.warning(unsupportedEncodingException + " EncodingID=" + s);
            }
            return new String(byArray, 0, n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void initNames() {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n = shortBuffer.get();
            int n2 = shortBuffer.get() & 0xFFFF;
            block4: for (int i = 0; i < n; ++i) {
                short s = shortBuffer.get();
                if (s != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s2 = shortBuffer.get();
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                int n3 = shortBuffer.get() & 0xFFFF;
                int n4 = (shortBuffer.get() & 0xFFFF) + n2;
                switch (s4) {
                    case 1: {
                        if (this.familyName != null && s3 != 1033) continue block4;
                        byteBuffer.position(n4);
                        byteBuffer.get(byArray, 0, n3);
                        this.familyName = this.makeString(byArray, n3, s2);
                        continue block4;
                    }
                    case 4: {
                        if (this.fullName != null && s3 != 1033) continue block4;
                        byteBuffer.position(n4);
                        byteBuffer.get(byArray, 0, n3);
                        this.fullName = this.makeString(byArray, n3, s2);
                    }
                }
            }
        }
    }

    protected String lookupName(short s, int n) {
        String string = null;
        byte[] byArray = new byte[1024];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            int n3 = shortBuffer.get() & 0xFFFF;
            for (int i = 0; i < n2; ++i) {
                short s2 = shortBuffer.get();
                if (s2 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                int n4 = shortBuffer.get() & 0xFFFF;
                int n5 = (shortBuffer.get() & 0xFFFF) + n3;
                if (s5 != n || (string != null || s4 != 1033) && s4 != s) continue;
                byteBuffer.position(n5);
                byteBuffer.get(byArray, 0, n4);
                string = this.makeString(byArray, n4, s3);
                if (s4 != s) continue;
                return string;
            }
        }
        return string;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    private void initBWGlyphs() {
        if ("Courier New".equals(this.fullName)) {
            this.bwGlyphs = new int[2];
            CharToGlyphMapper charToGlyphMapper = this.getMapper();
            this.bwGlyphs[0] = charToGlyphMapper.charToGlyph('W');
            this.bwGlyphs[1] = charToGlyphMapper.charToGlyph('w');
        }
    }

    private native long createScaler(int var1, int var2, boolean var3, int[] var4);

    protected synchronized long getScaler() {
        if (this.pScaler == 0L) {
            this.initBWGlyphs();
            this.pScaler = this.createScaler(this.fileSize, this.fontIndex, this.supportsCJK, this.bwGlyphs);
            if (this.pScaler != 0L) {
                Disposer.addObjectRecord(this, new FileFont.FileFontDisposer(this.pScaler));
            } else {
                this.pScaler = TrueTypeFont.getNullScaler();
                FontManager.deRegisterBadFont(this);
            }
        }
        return this.pScaler;
    }

    public String getPostscriptName() {
        String string = this.lookupName((short)1033, 6);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            return this.fullName;
        }
        short s = FontManager.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 4);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    public String getFamilyName(Locale locale) {
        if (locale == null) {
            return this.familyName;
        }
        short s = FontManager.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 1);
        if (string == null) {
            return this.familyName;
        }
        return string;
    }

    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new TrueTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    protected void initAllNames(int n, HashSet hashSet) {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            int n3 = shortBuffer.get() & 0xFFFF;
            for (int i = 0; i < n2; ++i) {
                short s = shortBuffer.get();
                if (s != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s2 = shortBuffer.get();
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                int n4 = shortBuffer.get() & 0xFFFF;
                int n5 = (shortBuffer.get() & 0xFFFF) + n3;
                if (s4 != n) continue;
                byteBuffer.position(n5);
                byteBuffer.get(byArray, 0, n4);
                hashSet.add(this.makeString(byArray, n4, s2));
            }
        }
    }

    String[] getAllFamilyNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(1, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    String[] getAllFullNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(4, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    synchronized native Point2D.Float getGlyphPoint(long var1, int var3, int var4);

    private char[] getGaspTable() {
        if (this.gaspTable != null) {
            return this.gaspTable;
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1734439792);
        if (byteBuffer == null) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        char c = charBuffer.get();
        if (c > '\u0001') {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        char c2 = charBuffer.get();
        if (4 + c2 * 4 > this.getTableSize(1734439792)) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        this.gaspTable = new char[2 * c2];
        charBuffer.get(this.gaspTable);
        return this.gaspTable;
    }

    public boolean useAAForPtSize(int n) {
        char[] cArray = this.getGaspTable();
        if (cArray.length > 0) {
            for (int i = 0; i < cArray.length; i += 2) {
                if (n > cArray[i]) continue;
                return (cArray[i + 1] & 2) != 0;
            }
            return true;
        }
        if (this.style == 1) {
            return true;
        }
        return n <= 8 || n >= 18;
    }

    public boolean hasSupplementaryChars() {
        return ((TrueTypeGlyphMapper)this.getMapper()).hasSupplementaryChars();
    }

    public String toString() {
        return "** TrueType Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " fileName=" + this.getPublicFileName();
    }

    class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }

    private static class TTDisposerRecord
    implements DisposerRecord {
        FileChannel channel = null;

        private TTDisposerRecord() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dispose() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.channel = null;
            }
        }
    }
}

