/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactoryFinder;
import javax.xml.validation.SecuritySupport;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SchemaFactory {
    private static SecuritySupport ss = new SecuritySupport();

    protected SchemaFactory() {
    }

    public static final SchemaFactory newInstance(String string) {
        SchemaFactory schemaFactory;
        ClassLoader classLoader = ss.getContextClassLoader();
        if (classLoader == null) {
            classLoader = SchemaFactory.class.getClassLoader();
        }
        if ((schemaFactory = new SchemaFactoryFinder(classLoader).newFactory(string)) == null) {
            throw new IllegalArgumentException("No SchemaFactory that implements the schema language specified by: " + string + " could be loaded");
        }
        return schemaFactory;
    }

    public static SchemaFactory newInstance(String string, String string2, ClassLoader classLoader) {
        SchemaFactory schemaFactory;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ss.getContextClassLoader();
        }
        if ((schemaFactory = new SchemaFactoryFinder(classLoader2).createInstance(string2)) == null) {
            throw new IllegalArgumentException("Factory " + string2 + " could not be loaded to implement the schema language specified by: " + string);
        }
        if (schemaFactory.isSchemaLanguageSupported(string)) {
            return schemaFactory;
        }
        throw new IllegalArgumentException("Factory " + schemaFactory.getClass().getName() + " does not implement the schema language specified by: " + string);
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract ErrorHandler getErrorHandler();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public abstract LSResourceResolver getResourceResolver();

    public Schema newSchema(Source source) throws SAXException {
        return this.newSchema(new Source[]{source});
    }

    public Schema newSchema(File file) throws SAXException {
        return this.newSchema(new StreamSource(file));
    }

    public Schema newSchema(URL uRL) throws SAXException {
        return this.newSchema(new StreamSource(uRL.toExternalForm()));
    }

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;
}

