/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    private static View[] ZERO = new View[0];
    private View[] children = new View[1];
    private int nchildren = 0;
    private short left;
    private short right;
    private short top;
    private short bottom;
    private Rectangle childAlloc = new Rectangle();

    public CompositeView(Element element) {
        super(element);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        if (viewFactory == null) {
            return;
        }
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = viewFactory.create(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.nchildren == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public int getViewCount() {
        return this.nchildren;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        int n4;
        if (viewArray == null) {
            viewArray = ZERO;
        }
        for (n4 = n; n4 < n + n2; ++n4) {
            if (this.children[n4].getParent() == this) {
                this.children[n4].setParent(null);
            }
            this.children[n4] = null;
        }
        n4 = viewArray.length - n2;
        int n5 = n + n2;
        int n6 = this.nchildren - n5;
        int n7 = n5 + n4;
        if (this.nchildren + n4 >= this.children.length) {
            n3 = Math.max(2 * this.children.length, this.nchildren + n4);
            View[] viewArray2 = new View[n3];
            System.arraycopy(this.children, 0, viewArray2, 0, n);
            System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
            System.arraycopy(this.children, n5, viewArray2, n7, n6);
            this.children = viewArray2;
        } else {
            System.arraycopy(this.children, n5, this.children, n7, n6);
            System.arraycopy(viewArray, 0, this.children, n, viewArray.length);
        }
        this.nchildren += n4;
        for (n3 = 0; n3 < viewArray.length; ++n3) {
            viewArray[n3].setParent(this);
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        View view;
        int n2;
        boolean bl = bias == Position.Bias.Backward;
        int n3 = n2 = bl ? Math.max(0, n - 1) : n;
        if (bl && n2 < this.getStartOffset()) {
            return null;
        }
        int n4 = this.getViewIndexAtPosition(n2);
        if (n4 != -1 && n4 < this.getViewCount() && (view = this.getView(n4)) != null && n2 >= view.getStartOffset() && n2 < view.getEndOffset()) {
            Shape shape2 = this.getChildAllocation(n4, shape);
            if (shape2 == null) {
                return null;
            }
            Shape shape3 = view.modelToView(n, shape2, bias);
            if (shape3 == null && view.getEndOffset() == n && ++n4 < this.getViewCount()) {
                view = this.getView(n4);
                shape3 = view.modelToView(n, this.getChildAllocation(n4, shape), bias);
            }
            return shape3;
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        View view;
        Rectangle rectangle2;
        Rectangle rectangle3;
        if (n == this.getStartOffset() && n2 == this.getEndOffset()) {
            return shape;
        }
        View view2 = this.getViewAtPosition(bias == Position.Bias.Backward ? Math.max(0, n - 1) : n, rectangle3 = new Rectangle(rectangle2 = this.getInsideAllocation(shape)));
        if (view2 == (view = this.getViewAtPosition(bias2 == Position.Bias.Backward ? Math.max(0, n2 - 1) : n2, rectangle = new Rectangle(rectangle2)))) {
            if (view2 == null) {
                return shape;
            }
            return view2.modelToView(n, bias, n2, bias2, rectangle3);
        }
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view3;
            Rectangle rectangle4;
            View view4 = this.getView(i);
            if (view4 != view2 && view4 != view) continue;
            Rectangle rectangle5 = new Rectangle();
            if (view4 == view2) {
                rectangle4 = view2.modelToView(n, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3).getBounds();
                view3 = view;
            } else {
                rectangle4 = view.modelToView(view.getStartOffset(), Position.Bias.Forward, n2, bias2, rectangle).getBounds();
                view3 = view2;
            }
            while (++i < n3 && (view4 = this.getView(i)) != view3) {
                rectangle5.setBounds(rectangle2);
                this.childAllocation(i, rectangle5);
                rectangle4.add(rectangle5);
            }
            if (view3 != null) {
                Shape shape2 = view3 == view ? view.modelToView(view.getStartOffset(), Position.Bias.Forward, n2, bias2, rectangle) : view2.modelToView(n, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3);
                if (shape2 instanceof Rectangle) {
                    rectangle4.add((Rectangle)shape2);
                } else {
                    rectangle4.add(shape2.getBounds());
                }
            }
            return rectangle4;
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (this.isBefore((int)f, (int)f2, rectangle)) {
            int n = -1;
            try {
                n = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 3, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n == -1) {
                n = this.getStartOffset();
                biasArray[0] = Position.Bias.Forward;
            }
            return n;
        }
        if (this.isAfter((int)f, (int)f2, rectangle)) {
            int n = -1;
            try {
                n = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 7, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n == -1) {
                n = this.getEndOffset() - 1;
                biasArray[0] = Position.Bias.Forward;
            }
            return n;
        }
        View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
        if (view != null) {
            return view.viewToModel(f, f2, rectangle, biasArray);
        }
        return -1;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle = this.getInsideAllocation(shape);
        switch (n2) {
            case 1: {
                return this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 5: {
                return this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 3: {
                return this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
            case 7: {
                return this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
            }
        }
        throw new IllegalArgumentException("Bad direction: " + n2);
    }

    public int getViewIndex(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --n;
        }
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            return this.getViewIndexAtPosition(n);
        }
        return -1;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        int n2 = this.getViewIndexAtPosition(n);
        if (n2 >= 0 && n2 < this.getViewCount()) {
            View view = this.getView(n2);
            if (rectangle != null) {
                this.childAllocation(n2, rectangle);
            }
            return view;
        }
        return null;
    }

    protected int getViewIndexAtPosition(int n) {
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.childAlloc.setBounds(rectangle);
            this.childAlloc.x += this.getLeftInset();
            this.childAlloc.y += this.getTopInset();
            this.childAlloc.width -= this.getLeftInset() + this.getRightInset();
            this.childAlloc.height -= this.getTopInset() + this.getBottomInset();
            return this.childAlloc;
        }
        return null;
    }

    protected void setParagraphInsets(AttributeSet attributeSet) {
        this.top = (short)StyleConstants.getSpaceAbove(attributeSet);
        this.left = (short)StyleConstants.getLeftIndent(attributeSet);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributeSet);
        this.right = (short)StyleConstants.getRightIndent(attributeSet);
    }

    protected void setInsets(short s, short s2, short s3, short s4) {
        this.top = s;
        this.left = s2;
        this.right = s4;
        this.bottom = s3;
    }

    protected short getLeftInset() {
        return this.left;
    }

    protected short getRightInset() {
        return this.right;
    }

    protected short getTopInset() {
        return this.top;
    }

    protected short getBottomInset() {
        return this.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    protected int getNextEastWestVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }
}

