/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ValueExp;

class NumericValueExp
extends QueryEval
implements ValueExp {
    private static final long oldSerialVersionUID = -6227876276058904000L;
    private static final long newSerialVersionUID = -4679739485102359104L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("longVal", Long.TYPE), new ObjectStreamField("doubleVal", Double.TYPE), new ObjectStreamField("valIsLong", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("val", Number.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private Number val = new Double(0.0);
    private static boolean compat;

    public NumericValueExp() {
    }

    NumericValueExp(Number number) {
        this.val = number;
    }

    public double doubleValue() {
        if (this.val instanceof Long || this.val instanceof Integer) {
            return this.val.longValue();
        }
        return this.val.doubleValue();
    }

    public long longValue() {
        if (this.val instanceof Long || this.val instanceof Integer) {
            return this.val.longValue();
        }
        return (long)this.val.doubleValue();
    }

    public boolean isLong() {
        return this.val instanceof Long || this.val instanceof Integer;
    }

    public String toString() {
        if (this.val instanceof Long || this.val instanceof Integer) {
            return String.valueOf(this.val.longValue());
        }
        return String.valueOf(this.val.doubleValue());
    }

    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            double d = getField.get("doubleVal", 0.0);
            if (getField.defaulted("doubleVal")) {
                throw new NullPointerException("doubleVal");
            }
            long l = getField.get("longVal", 0L);
            if (getField.defaulted("longVal")) {
                throw new NullPointerException("longVal");
            }
            boolean bl = getField.get("valIsLong", false);
            if (getField.defaulted("valIsLong")) {
                throw new NullPointerException("valIsLong");
            }
            this.val = bl ? (Number)new Long(l) : (Number)new Double(d);
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("doubleVal", this.doubleValue());
            putField.put("longVal", this.longValue());
            putField.put("valIsLong", this.isLong());
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -6227876276058904000L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -4679739485102359104L;
        }
    }
}

