/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.poolSize >= this.corePoolSize || !this.addIfUnderCorePoolSize(runnable)) {
            if (this.runState == 0 && this.workQueue.offer(runnable)) {
                if (this.runState != 0 || this.poolSize == 0) {
                    this.ensureQueuedTaskHandled(runnable);
                }
            } else if (!this.addIfUnderMaximumPoolSize(runnable)) {
                this.reject(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread addThread(Runnable runnable) {
        Thread thread;
        block6: {
            Worker worker = new Worker(runnable);
            thread = this.threadFactory.newThread(worker);
            boolean bl = false;
            if (thread != null) {
                if (thread.isAlive()) {
                    throw new IllegalThreadStateException();
                }
                worker.thread = thread;
                this.workers.add(worker);
                int n = ++this.poolSize;
                if (n > this.largestPoolSize) {
                    this.largestPoolSize = n;
                }
                try {
                    thread.start();
                    bl = true;
                    Object var7_6 = null;
                    if (bl) break block6;
                    this.workers.remove(worker);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!bl) {
                        this.workers.remove(worker);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable runnable) {
        Thread thread = null;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.corePoolSize && this.runState == 0) {
                thread = this.addThread(runnable);
            }
            Object var5_4 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderMaximumPoolSize(Runnable runnable) {
        Thread thread = null;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize && this.runState == 0) {
                thread = this.addThread(runnable);
            }
            Object var5_4 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueuedTaskHandled(Runnable runnable) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        boolean bl = false;
        Thread thread = null;
        try {
            int n = this.runState;
            if (n != 0 && this.workQueue.remove(runnable)) {
                bl = true;
            } else if (n < 2 && this.poolSize < Math.max(this.corePoolSize, 1) && !this.workQueue.isEmpty()) {
                thread = this.addThread(null);
            }
            Object var7_6 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (bl) {
            this.reject(runnable);
        }
    }

    void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    Runnable getTask() {
        while (true) {
            try {
                do {
                    int n;
                    if ((n = this.runState) > 1) {
                        return null;
                    }
                    Runnable runnable = n == 1 ? (Runnable)this.workQueue.poll() : (this.poolSize > this.corePoolSize || this.allowCoreThreadTimeOut ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take());
                    if (runnable == null) continue;
                    return runnable;
                } while (!this.workerCanExit());
                if (this.runState >= 1) {
                    this.interruptIdleWorkers();
                }
                return null;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean workerCanExit() {
        boolean bl;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            bl = this.runState >= 2 || this.workQueue.isEmpty() || this.allowCoreThreadTimeOut && this.poolSize > Math.max(1, this.corePoolSize);
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                worker.interruptIfIdle();
            }
            Object var5_4 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker worker) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            this.workers.remove(worker);
            if (--this.poolSize == 0) {
                this.tryTerminate();
            }
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    private void tryTerminate() {
        if (this.poolSize == 0) {
            int n = this.runState;
            if (n < 2 && !this.workQueue.isEmpty()) {
                n = 0;
                this.addThread(null);
            }
            if (n == 2 || n == 1) {
                this.runState = 3;
                this.termination.signalAll();
                this.terminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n;
            if (securityManager != null) {
                for (Worker object : this.workers) {
                    securityManager.checkAccess(object.thread);
                }
            }
            if ((n = this.runState) < 1) {
                this.runState = 1;
            }
            try {
                for (Worker worker : this.workers) {
                    worker.interruptIfIdle();
                }
            }
            catch (SecurityException securityException) {
                this.runState = n;
                throw securityException;
            }
            this.tryTerminate();
            Object var7_9 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n;
            if (securityManager != null) {
                for (Worker list2 : this.workers) {
                    securityManager.checkAccess(list2.thread);
                }
            }
            if ((n = this.runState) < 2) {
                this.runState = 2;
            }
            try {
                for (Worker worker : this.workers) {
                    worker.interruptNow();
                }
            }
            catch (SecurityException securityException) {
                this.runState = n;
                throw securityException;
            }
            List<Runnable> list = this.drainQueue();
            this.tryTerminate();
            List<Runnable> list2 = list;
            Object var7_11 = null;
            reentrantLock.unlock();
            return list2;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    private List<Runnable> drainQueue() {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        this.workQueue.drainTo(arrayList);
        while (!this.workQueue.isEmpty()) {
            Iterator iterator = this.workQueue.iterator();
            try {
                Runnable runnable;
                if (!iterator.hasNext() || !this.workQueue.remove(runnable = (Runnable)iterator.next())) continue;
                arrayList.add(runnable);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        return arrayList;
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    boolean isStopped() {
        return this.runState == 2;
    }

    public boolean isTerminating() {
        int n = this.runState;
        return n == 1 || n == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl2 = true;
                    Object var9_7 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        reentrantLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = this.corePoolSize - n;
            this.corePoolSize = n;
            if (n2 < 0) {
                Thread thread;
                int n3 = this.workQueue.size();
                while (n2++ < 0 && n3-- > 0 && this.poolSize < n && (thread = this.addThread(null)) != null) {
                }
            } else if (n2 > 0 && this.poolSize > n) {
                try {
                    Iterator<Worker> iterator = this.workers.iterator();
                    while (iterator.hasNext() && n2-- > 0 && this.poolSize > n && this.workQueue.remainingCapacity() == 0) {
                        iterator.next().interruptIfIdle();
                    }
                }
                catch (SecurityException securityException) {
                }
            }
            Object var7_8 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int n) {
        if (n <= 0 || n < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2;
            this.maximumPoolSize = n;
            if (n2 > 0 && this.poolSize > n) {
                try {
                    Iterator<Worker> iterator = this.workers.iterator();
                    for (n2 = this.maximumPoolSize - n; iterator.hasNext() && n2 > 0 && this.poolSize > n; --n2) {
                        iterator.next().interruptIfIdle();
                    }
                }
                catch (SecurityException securityException) {
                }
            }
            Object var6_6 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = timeUnit.toNanos(l);
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        return this.getQueue().remove(runnable);
    }

    public void purge() {
        try {
            Iterator iterator = this.getQueue().iterator();
            while (iterator.hasNext()) {
                Future future;
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof Future) || !(future = (Future)((Object)runnable)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return;
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (Worker worker : this.workers) {
                if (!worker.isActive()) continue;
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
                if (!worker.isActive()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            Object var7_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
            }
            long l2 = l;
            Object var7_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    private final class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;
        volatile boolean hasRun = false;

        Worker(Runnable runnable) {
            this.firstTask = runnable;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock reentrantLock = this.runLock;
            if (reentrantLock.tryLock()) {
                try {
                    if (this.hasRun && this.thread != Thread.currentThread()) {
                        this.thread.interrupt();
                    }
                    Object var3_2 = null;
                    reentrantLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
        }

        void interruptNow() {
            if (this.hasRun) {
                this.thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable runnable) {
            ReentrantLock reentrantLock = this.runLock;
            reentrantLock.lock();
            try {
                if ((ThreadPoolExecutor.this.runState >= 2 || Thread.interrupted() && ThreadPoolExecutor.this.runState >= 2) && this.hasRun) {
                    this.thread.interrupt();
                }
                boolean bl = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, runnable);
                try {
                    runnable.run();
                    bl = true;
                    ThreadPoolExecutor.this.afterExecute(runnable, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException runtimeException) {
                    if (!bl) {
                        ThreadPoolExecutor.this.afterExecute(runnable, runtimeException);
                    }
                    throw runtimeException;
                }
                Object var6_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.hasRun = true;
                Runnable runnable = this.firstTask;
                this.firstTask = null;
                while (runnable != null || (runnable = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(runnable);
                    runnable = null;
                }
                Object var3_2 = null;
                ThreadPoolExecutor.this.workerDone(this);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ThreadPoolExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

