/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyStoreSpi {
    public abstract Key engineGetKey(String var1, char[] var2) throws NoSuchAlgorithmException, UnrecoverableKeyException;

    public abstract Certificate[] engineGetCertificateChain(String var1);

    public abstract Certificate engineGetCertificate(String var1);

    public abstract Date engineGetCreationDate(String var1);

    public abstract void engineSetKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public abstract void engineSetKeyEntry(String var1, byte[] var2, Certificate[] var3) throws KeyStoreException;

    public abstract void engineSetCertificateEntry(String var1, Certificate var2) throws KeyStoreException;

    public abstract void engineDeleteEntry(String var1) throws KeyStoreException;

    public abstract Enumeration<String> engineAliases();

    public abstract boolean engineContainsAlias(String var1);

    public abstract int engineSize();

    public abstract boolean engineIsKeyEntry(String var1);

    public abstract boolean engineIsCertificateEntry(String var1);

    public abstract String engineGetCertificateAlias(Certificate var1);

    public abstract void engineStore(OutputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException();
    }

    public abstract void engineLoad(InputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter == null) {
            this.engineLoad(null, null);
            return;
        }
        if (loadStoreParameter instanceof KeyStore.SimpleLoadStoreParameter) {
            char[] cArray;
            KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
            if (protectionParameter instanceof KeyStore.PasswordProtection) {
                cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
                CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
                PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
                try {
                    callbackHandler.handle(new Callback[]{passwordCallback});
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    throw new NoSuchAlgorithmException("Could not obtain password", unsupportedCallbackException);
                }
                cArray = passwordCallback.getPassword();
                passwordCallback.clearPassword();
                if (cArray == null) {
                    throw new NoSuchAlgorithmException("No password provided");
                }
            } else {
                throw new NoSuchAlgorithmException("ProtectionParameter must be PasswordProtection or CallbackHandlerProtection");
            }
            this.engineLoad(null, cArray);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        if (protectionParameter == null) {
            if (this.engineIsCertificateEntry(string)) {
                return new KeyStore.TrustedCertificateEntry(this.engineGetCertificate(string));
            }
            throw new UnrecoverableKeyException("requested entry requires a password");
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            if (this.engineIsCertificateEntry(string)) {
                throw new UnsupportedOperationException("trusted certificate entries are not password-protected");
            }
            if (this.engineIsKeyEntry(string)) {
                KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
                char[] cArray = passwordProtection.getPassword();
                Key key = this.engineGetKey(string, cArray);
                if (key instanceof PrivateKey) {
                    Certificate[] certificateArray = this.engineGetCertificateChain(string);
                    return new KeyStore.PrivateKeyEntry((PrivateKey)key, certificateArray);
                }
                if (key instanceof SecretKey) {
                    return new KeyStore.SecretKeyEntry((SecretKey)key);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (protectionParameter != null && !(protectionParameter instanceof KeyStore.PasswordProtection)) {
            throw new KeyStoreException("unsupported protection parameter");
        }
        KeyStore.PasswordProtection passwordProtection = null;
        if (protectionParameter != null) {
            passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            if (protectionParameter != null && passwordProtection.getPassword() != null) {
                throw new KeyStoreException("trusted certificate entries are not password-protected");
            }
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(string, trustedCertificateEntry.getTrustedCertificate());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            if (passwordProtection == null || passwordProtection.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create PrivateKeyEntry");
            }
            this.engineSetKeyEntry(string, ((KeyStore.PrivateKeyEntry)entry).getPrivateKey(), passwordProtection.getPassword(), ((KeyStore.PrivateKeyEntry)entry).getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            if (passwordProtection == null || passwordProtection.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create SecretKeyEntry");
            }
            this.engineSetKeyEntry(string, ((KeyStore.SecretKeyEntry)entry).getSecretKey(), passwordProtection.getPassword(), null);
            return;
        }
        throw new KeyStoreException("unsupported entry type: " + entry.getClass().getName());
    }

    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        if (clazz == KeyStore.TrustedCertificateEntry.class) {
            return this.engineIsCertificateEntry(string);
        }
        if (clazz == KeyStore.PrivateKeyEntry.class) {
            return this.engineIsKeyEntry(string) && this.engineGetCertificate(string) != null;
        }
        if (clazz == KeyStore.SecretKeyEntry.class) {
            return this.engineIsKeyEntry(string) && this.engineGetCertificate(string) == null;
        }
        return false;
    }
}

