/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarshalledObject<T>
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    private static final long serialVersionUID = 8988374069173025854L;

    public MarshalledObject(T t) throws IOException {
        if (t == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        MarshalledObjectOutputStream marshalledObjectOutputStream = new MarshalledObjectOutputStream((OutputStream)byteArrayOutputStream, byteArrayOutputStream2);
        marshalledObjectOutputStream.writeObject(t);
        marshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = marshalledObjectOutputStream.hadAnnotations() ? byteArrayOutputStream2.toByteArray() : null;
        int n = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            n = 31 * n + this.objBytes[i];
        }
        this.hash = n;
    }

    public T get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream byteArrayInputStream2 = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledObjectInputStream marshalledObjectInputStream = new MarshalledObjectInputStream(byteArrayInputStream, byteArrayInputStream2);
        Object object = marshalledObjectInputStream.readObject();
        marshalledObjectInputStream.close();
        return (T)object;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof MarshalledObject) {
            MarshalledObject marshalledObject = (MarshalledObject)object;
            if (this.objBytes == null || marshalledObject.objBytes == null) {
                return this.objBytes == marshalledObject.objBytes;
            }
            if (this.objBytes.length != marshalledObject.objBytes.length) {
                return false;
            }
            for (int i = 0; i < this.objBytes.length; ++i) {
                if (this.objBytes[i] == marshalledObject.objBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class MarshalledObjectInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledObjectInputStream(InputStream inputStream, InputStream inputStream2) throws IOException {
            super(inputStream);
            this.locIn = inputStream2 == null ? null : new ObjectInputStream(inputStream2);
        }

        protected Object readLocation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : this.locIn.readObject();
        }
    }

    private static class MarshalledObjectOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        MarshalledObjectOutputStream(OutputStream outputStream, OutputStream outputStream2) throws IOException {
            super(outputStream);
            this.useProtocolVersion(2);
            this.locOut = new ObjectOutputStream(outputStream2);
            this.hadAnnotations = false;
        }

        boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        protected void writeLocation(String string) throws IOException {
            this.hadAnnotations |= string != null;
            this.locOut.writeObject(string);
        }

        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }
}

