/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectIterator;
import java.io.Serializable;

public abstract class RoundRectangle2D
extends RectangularShape {
    protected RoundRectangle2D() {
    }

    public abstract double getArcWidth();

    public abstract double getArcHeight();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRoundRect(d, d2, d3, d4, this.getArcWidth(), this.getArcHeight());
    }

    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        if (this.isEmpty()) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = d5 + this.getWidth();
        double d8 = d6 + this.getHeight();
        if (d < d5 || d2 < d6 || d >= d7 || d2 >= d8) {
            return false;
        }
        double d9 = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double d10 = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        d5 += d9;
        if (d >= d4) {
            double d11;
            d5 = d7 - d9;
            if (d < d11) {
                return true;
            }
        }
        d6 += d10;
        if (d2 >= d3) {
            double d12;
            d6 = d8 - d10;
            if (d2 < d12) {
                return true;
            }
        }
        return (d = (d - d5) / d9) * d + (d2 = (d2 - d6) / d10) * d2 <= 1.0;
    }

    private int classify(double d, double d2, double d3, double d4) {
        if (d < d2) {
            return 0;
        }
        if (d < d2 + d4) {
            return 1;
        }
        if (d < d3 - d4) {
            return 2;
        }
        if (d < d3) {
            return 3;
        }
        return 4;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = d5 + this.getWidth();
        double d8 = d6 + this.getHeight();
        if (d + d3 <= d5 || d >= d7 || d2 + d4 <= d6 || d2 >= d8) {
            return false;
        }
        double d9 = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double d10 = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        int n = this.classify(d, d5, d7, d9);
        int n2 = this.classify(d + d3, d5, d7, d9);
        int n3 = this.classify(d2, d6, d8, d10);
        int n4 = this.classify(d2 + d4, d6, d8, d10);
        if (n == 2 || n2 == 2 || n3 == 2 || n4 == 2) {
            return true;
        }
        if (n < 2 && n2 > 2 || n3 < 2 && n4 > 2) {
            return true;
        }
        d = n2 == 1 ? (d = d + d3 - (d5 + d9)) : (d = d - (d7 - d9));
        d2 = n4 == 1 ? (d2 = d2 + d4 - (d6 + d10)) : (d2 = d2 - (d8 - d10));
        return (d /= d9) * d + (d2 /= d10) * d2 <= 1.0;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new RoundRectIterator(this, affineTransform);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        l += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        l += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L;
        l += java.lang.Double.doubleToLongBits(this.getArcWidth()) * 53L;
        return (int)(l += java.lang.Double.doubleToLongBits(this.getArcHeight()) * 59L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)object;
            return this.getX() == roundRectangle2D.getX() && this.getY() == roundRectangle2D.getY() && this.getWidth() == roundRectangle2D.getWidth() && this.getHeight() == roundRectangle2D.getHeight() && this.getArcWidth() == roundRectangle2D.getArcWidth() && this.getArcHeight() == roundRectangle2D.getArcHeight();
        }
        return false;
    }

    public static class Double
    extends RoundRectangle2D
    implements Serializable {
        public double x;
        public double y;
        public double width;
        public double height;
        public double arcwidth;
        public double archeight;
        private static final long serialVersionUID = 1048939333485206117L;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.setRoundRect(d, d2, d3, d4, d5, d6);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }

        public void setRoundRect(RoundRectangle2D roundRectangle2D) {
            this.x = roundRectangle2D.getX();
            this.y = roundRectangle2D.getY();
            this.width = roundRectangle2D.getWidth();
            this.height = roundRectangle2D.getHeight();
            this.arcwidth = roundRectangle2D.getArcWidth();
            this.archeight = roundRectangle2D.getArcHeight();
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    public static class Float
    extends RoundRectangle2D
    implements Serializable {
        public float x;
        public float y;
        public float width;
        public float height;
        public float arcwidth;
        public float archeight;
        private static final long serialVersionUID = -3423150618393866922L;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.setRoundRect(f, f2, f3, f4, f5, f6);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.arcwidth = (float)d5;
            this.archeight = (float)d6;
        }

        public void setRoundRect(RoundRectangle2D roundRectangle2D) {
            this.x = (float)roundRectangle2D.getX();
            this.y = (float)roundRectangle2D.getY();
            this.width = (float)roundRectangle2D.getWidth();
            this.height = (float)roundRectangle2D.getHeight();
            this.arcwidth = (float)roundRectangle2D.getArcWidth();
            this.archeight = (float)roundRectangle2D.getArcHeight();
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }
    }
}

