/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageDataContentHandler
extends Component
implements DataContentHandler {
    private static final Logger log = Logger.getLogger(ImageDataContentHandler.class.getName());
    private final DataFlavor[] flavor;

    public ImageDataContentHandler() {
        String[] stringArray = ImageIO.getReaderMIMETypes();
        this.flavor = new DataFlavor[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.flavor[i] = new ActivationDataFlavor(Image.class, stringArray[i], "Image");
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavor;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        for (DataFlavor dataFlavor2 : this.flavor) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return this.getContent(dataSource);
        }
        return null;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return ImageIO.read(new BufferedInputStream(dataSource.getInputStream()));
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        try {
            BufferedImage bufferedImage;
            if (object instanceof BufferedImage) {
                bufferedImage = (BufferedImage)object;
            } else if (object instanceof Image) {
                bufferedImage = this.render((Image)object);
            } else {
                throw new IOException("ImageDataContentHandler requires Image object, was given object of type " + object.getClass().toString());
            }
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            if (imageWriter == null) {
                throw new IOException("Unsupported mime type:" + string);
            }
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
            imageWriter.dispose();
            imageOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Unable to encode the image to a stream " + exception.getMessage());
        }
    }

    private BufferedImage render(Image image) throws InterruptedException {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForAll();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

