/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class WriterUtility {
    public static final String START_COMMENT = "<!--";
    public static final String END_COMMENT = "-->";
    public static final String DEFAULT_ENCODING = " encoding=\"utf-8\"";
    public static final String DEFAULT_XMLDECL = "<?xml version=\"1.0\" ?>";
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String SPACE = " ";
    public static final String UTF_8 = "utf-8";
    static final boolean DEBUG_XML_CONTENT = false;
    boolean fEscapeCharacters = true;
    Writer fWriter = null;
    CharsetEncoder fEncoder;

    public WriterUtility() {
        this.fEncoder = this.getDefaultEncoder();
    }

    public WriterUtility(Writer writer) {
        this.fWriter = writer;
        if (writer instanceof OutputStreamWriter) {
            String string = ((OutputStreamWriter)writer).getEncoding();
            if (string != null) {
                this.fEncoder = Charset.forName(string).newEncoder();
            }
        } else if (writer instanceof FileWriter) {
            String string = ((FileWriter)writer).getEncoding();
            if (string != null) {
                this.fEncoder = Charset.forName(string).newEncoder();
            }
        } else {
            this.fEncoder = this.getDefaultEncoder();
        }
    }

    public void setWriter(Writer writer) {
        this.fWriter = writer;
    }

    public void setEscapeCharacters(boolean bl) {
        this.fEscapeCharacters = bl;
    }

    public boolean getEscapeCharacters() {
        return this.fEscapeCharacters;
    }

    public void writeXMLContent(char[] cArray, int n, int n2) throws IOException {
        this.writeXMLContent(cArray, n, n2, this.getEscapeCharacters());
    }

    private void writeXMLContent(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        block5: for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (this.fEncoder != null && !this.fEncoder.canEncode(c)) {
                this.fWriter.write(cArray, n4, i - n4);
                this.fWriter.write("&#x");
                this.fWriter.write(Integer.toHexString(c));
                this.fWriter.write(59);
                n4 = i + 1;
            }
            switch (c) {
                case '<': {
                    if (!bl) continue block5;
                    this.fWriter.write(cArray, n4, i - n4);
                    this.fWriter.write("&lt;");
                    n4 = i + 1;
                    continue block5;
                }
                case '&': {
                    if (!bl) continue block5;
                    this.fWriter.write(cArray, n4, i - n4);
                    this.fWriter.write("&amp;");
                    n4 = i + 1;
                    continue block5;
                }
                case '>': {
                    if (!bl) continue block5;
                    this.fWriter.write(cArray, n4, i - n4);
                    this.fWriter.write("&gt;");
                    n4 = i + 1;
                }
            }
        }
        this.fWriter.write(cArray, n4, n3 - n4);
    }

    public void writeXMLContent(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        this.writeXMLContent(string.toCharArray(), 0, string.length());
    }

    public void writeXMLAttributeValue(String string) throws IOException {
        this.writeXMLContent(string.toCharArray(), 0, string.length(), true);
    }

    private CharsetEncoder getDefaultEncoder() {
        try {
            String string = SecuritySupport.getSystemProperty("file.encoding");
            if (string != null) {
                return Charset.forName(string).newEncoder();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

