/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerByte<BeanT>
extends Lister<BeanT, byte[], Byte, ByteArrayPack> {
    private PrimitiveArrayListerByte() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Byte.TYPE, new PrimitiveArrayListerByte());
    }

    @Override
    public ListIterator<Byte> iterator(final byte[] byArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Byte>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < byArray.length;
            }

            @Override
            public Byte next() {
                return byArray[this.idx++];
            }
        };
    }

    @Override
    public ByteArrayPack startPacking(BeanT BeanT, Accessor<BeanT, byte[]> accessor) {
        return new ByteArrayPack();
    }

    @Override
    public void addToPack(ByteArrayPack byteArrayPack, Byte by) {
        byteArrayPack.add(by);
    }

    @Override
    public void endPacking(ByteArrayPack byteArrayPack, BeanT BeanT, Accessor<BeanT, byte[]> accessor) throws AccessorException {
        accessor.set(BeanT, byteArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, byte[]> accessor) throws AccessorException {
        accessor.set(BeanT, new byte[0]);
    }

    static final class ByteArrayPack {
        byte[] buf = new byte[16];
        int size;

        ByteArrayPack() {
        }

        void add(Byte by) {
            if (this.buf.length == this.size) {
                byte[] byArray = new byte[this.buf.length * 2];
                System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
                this.buf = byArray;
            }
            if (by != null) {
                this.buf[this.size++] = by;
            }
        }

        byte[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.buf, 0, byArray, 0, this.size);
            return byArray;
        }
    }
}

