/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpUnsignedInt;

public class SnmpTimeticks
extends SnmpUnsignedInt {
    static final String name = "TimeTicks";
    private static final long serialVersionUID = -5486435222360030630L;

    public SnmpTimeticks(int n) throws IllegalArgumentException {
        super(n);
    }

    public SnmpTimeticks(Integer n) throws IllegalArgumentException {
        super(n);
    }

    public SnmpTimeticks(long l) throws IllegalArgumentException {
        super(l > 0L ? l & 0xFFFFFFFFL : l);
    }

    public SnmpTimeticks(Long l) throws IllegalArgumentException {
        this((long)l);
    }

    public static final String printTimeTicks(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = (int)((l /= 100L) / 86400L);
        int n2 = (int)((l %= 86400L) / 3600L);
        int n3 = (int)((l %= 3600L) / 60L);
        int n4 = (int)(l % 60L);
        if (n == 0) {
            stringBuffer.append(n2 + ":" + n3 + ":" + n4);
            return stringBuffer.toString();
        }
        if (n == 1) {
            stringBuffer.append("1 day ");
        } else {
            stringBuffer.append(n + " days ");
        }
        stringBuffer.append(n2 + ":" + n3 + ":" + n4);
        return stringBuffer.toString();
    }

    public final String toString() {
        return SnmpTimeticks.printTimeTicks(this.value);
    }

    public final String getTypeName() {
        return name;
    }
}

