/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.pept.transport.ByteBufferPool;
import com.sun.corba.se.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBufferPoolImpl
implements ByteBufferPool {
    private ORB itsOrb;
    private int itsByteBufferSize;
    private ArrayList itsPool;
    private int itsObjectCounter = 0;
    private boolean debug;

    public ByteBufferPoolImpl(ORB oRB) {
        this.itsByteBufferSize = oRB.getORBData().getGIOPFragmentSize();
        this.itsPool = new ArrayList();
        this.itsOrb = oRB;
        this.debug = oRB.transportDebugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer(int n) {
        ByteBuffer byteBuffer = null;
        if (n <= this.itsByteBufferSize && !this.itsOrb.getORBData().disableDirectByteBufferUse()) {
            int n2;
            ArrayList arrayList = this.itsPool;
            synchronized (arrayList) {
                n2 = this.itsPool.size();
                if (n2 > 0) {
                    byteBuffer = (ByteBuffer)this.itsPool.remove(n2 - 1);
                    byteBuffer.clear();
                }
            }
            if (n2 <= 0) {
                byteBuffer = ByteBuffer.allocateDirect(this.itsByteBufferSize);
            }
            ++this.itsObjectCounter;
        } else {
            byteBuffer = ByteBuffer.allocate(n);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            ArrayList arrayList = this.itsPool;
            synchronized (arrayList) {
                Object object;
                boolean bl = false;
                int n = 0;
                if (this.debug) {
                    for (int i = 0; i < this.itsPool.size() && !bl; ++i) {
                        object = (ByteBuffer)this.itsPool.get(i);
                        if (byteBuffer != object) continue;
                        bl = true;
                        n = System.identityHashCode(byteBuffer);
                    }
                }
                if (!bl || !this.debug) {
                    this.itsPool.add(byteBuffer);
                } else {
                    String string = Thread.currentThread().getName();
                    object = new Throwable(string + ": Duplicate ByteBuffer reference (" + n + ")");
                    ((Throwable)object).printStackTrace(System.out);
                }
            }
            --this.itsObjectCounter;
        } else {
            byteBuffer = null;
        }
    }

    public int activeCount() {
        return this.itsObjectCounter;
    }
}

