/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolChooser;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolManagerImpl
implements ThreadPoolManager {
    private ThreadPool threadPool;
    private ThreadGroup threadGroup = this.getThreadGroup();
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");
    private static AtomicInteger tgCount = new AtomicInteger();

    public ThreadPoolManagerImpl() {
        this.threadPool = new ThreadPoolImpl(this.threadGroup, "default-threadpool");
    }

    private ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        try {
            threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    try {
                        while (threadGroup2 != null) {
                            threadGroup = threadGroup2;
                            threadGroup2 = threadGroup.getParent();
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new ThreadGroup(threadGroup, "ORB ThreadGroup " + tgCount.getAndIncrement());
                }
            });
        }
        catch (SecurityException securityException) {
            threadGroup = Thread.currentThread().getThreadGroup();
        }
        return threadGroup;
    }

    public void close() {
        try {
            this.threadPool.close();
        }
        catch (IOException iOException) {
            wrapper.threadPoolCloseError();
        }
        try {
            boolean bl = this.threadGroup.isDestroyed();
            int n = this.threadGroup.activeCount();
            int n2 = this.threadGroup.activeGroupCount();
            if (bl) {
                wrapper.threadGroupIsDestroyed(this.threadGroup);
            } else {
                if (n > 0) {
                    wrapper.threadGroupHasActiveThreadsInClose(this.threadGroup, n);
                }
                if (n2 > 0) {
                    wrapper.threadGroupHasSubGroupsInClose(this.threadGroup, n2);
                }
                this.threadGroup.destroy();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            wrapper.threadGroupDestroyFailed(illegalThreadStateException, (Object)this.threadGroup);
        }
        this.threadGroup = null;
    }

    public ThreadPool getThreadPool(String string) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    public ThreadPool getThreadPool(int n) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    public int getThreadPoolNumericId(String string) {
        return 0;
    }

    public String getThreadPoolStringId(int n) {
        return "";
    }

    public ThreadPool getDefaultThreadPool() {
        return this.threadPool;
    }

    public ThreadPoolChooser getThreadPoolChooser(String string) {
        return null;
    }

    public ThreadPoolChooser getThreadPoolChooser(int n) {
        return null;
    }

    public void setThreadPoolChooser(String string, ThreadPoolChooser threadPoolChooser) {
    }

    public int getThreadPoolChooserNumericId(String string) {
        return 0;
    }
}

