/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.PGPData;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.content.SPKIData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Logger log = Logger.getLogger(KeyInfo.class.getName());
    List _internalKeyResolvers = new ArrayList();
    List _storageResolvers = new ArrayList();
    static boolean _alreadyInitialized = false;

    public KeyInfo(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this._doc, string));
    }

    public void add(KeyName keyName) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyName.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this._doc, element));
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this._doc, dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this._doc, rSAKeyValue));
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void add(KeyValue keyValue) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this._doc, string));
    }

    public void add(MgmtData mgmtData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(mgmtData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(PGPData pGPData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(pGPData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this._doc, string, transforms, string2));
    }

    public void add(RetrievalMethod retrievalMethod) {
        if (this._state == 0) {
            this._constructionElement.appendChild(retrievalMethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(SPKIData sPKIData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(sPKIData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(X509Data x509Data) {
        if (this._state == 0) {
            this._constructionElement.appendChild(x509Data.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this._state == 0) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            this._constructionElement.appendChild(xMLCipher.martial(encryptedKey));
        }
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int n = 0;
        NodeList nodeList = this._constructionElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyName", n);
        if (element != null) {
            return new KeyName(element, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyValue", n);
        if (element != null) {
            return new KeyValue(element, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "MgmtData", n);
        if (element != null) {
            return new MgmtData(element, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "PGPData", n);
        if (element != null) {
            return new PGPData(element, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RetrievalMethod", n);
        if (element != null) {
            return new RetrievalMethod(element, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SPKIData", n);
        if (element != null) {
            return new SPKIData(element, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Data", n);
        if (element != null) {
            return new X509Data(element, this._baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectXencNode(this._constructionElement.getFirstChild(), "EncryptedKey", n);
        if (element != null) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(4, null);
            return xMLCipher.loadEncryptedKey(element);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++n2 != n) continue;
            return (Element)node;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._constructionElement.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a key using the per-KeyInfo key resolvers");
            }
            return publicKey;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a key using the per-KeyInfo key resolvers");
        }
        if ((publicKey = this.getPublicKeyFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a key using the system-wide key resolvers");
            }
            return publicKey;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a key using the system-wide key resolvers");
        }
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    PublicKey publicKey;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (publicKey = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            }
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    PublicKey publicKey;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (publicKey = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a X509Certificate using the per-KeyInfo key resolvers");
            }
            return x509Certificate;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        }
        if ((x509Certificate = this.getX509CertificateFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a X509Certificate using the system-wide key resolvers");
            }
            return x509Certificate;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a X509Certificate using the system-wide key resolvers");
        }
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers");
        }
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    X509Certificate x509Certificate;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (x509Certificate = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return x509Certificate;
                }
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers");
        }
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            }
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    X509Certificate x509Certificate;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (x509Certificate = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return x509Certificate;
                }
            }
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey secretKey = this.getSecretKeyFromInternalResolvers();
        if (secretKey != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a secret key using the per-KeyInfo key resolvers");
            }
            return secretKey;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        }
        if ((secretKey = this.getSecretKeyFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a secret key using the system-wide key resolvers");
            }
            return secretKey;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a secret key using the system-wide key resolvers");
        }
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolver.resolveSecretKey((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    SecretKey secretKey;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (secretKey = keyResolver.resolveSecretKey((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            }
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    StorageResolver storageResolver = null;
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) || (object = keyResolverSpi.engineResolveSecretKey((Element)node, this.getBaseURI(), storageResolver)) == null) continue;
                    return object;
                }
                for (int j = 0; j < this._storageResolvers.size(); ++j) {
                    SecretKey secretKey;
                    object = (StorageResolver)this._storageResolvers.get(j);
                    if (!keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) || (secretKey = keyResolverSpi.engineResolveSecretKey((Element)node, this.getBaseURI(), (StorageResolver)object)) == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        this._internalKeyResolvers.add(keyResolverSpi);
    }

    int lengthInternalKeyResolver() {
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return (KeyResolverSpi)this._internalKeyResolvers.get(n);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (storageResolver != null) {
            this._storageResolvers.add(storageResolver);
        }
    }

    List getStorageResolvers() {
        return this._storageResolvers;
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (log == null) {
                log = Logger.getLogger(KeyInfo.class.getName());
                log.log(Level.SEVERE, "Had to assign log in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }
}

