/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.https;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.X509DeployKeyManager;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.security.X509ExtendedDeployTrustManager;
import com.sun.deploy.services.ServiceManager;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class Handler
extends sun.net.www.protocol.https.Handler {
    protected URLConnection openConnection(URL uRL) throws IOException {
        Initializer.init();
        return super.openConnection(uRL);
    }

    static class Initializer {
        Initializer() {
        }

        static void init() {
        }

        static {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Object object;
                        TrustManager[] trustManagerArray;
                        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                            BrowserKeystore.registerSecurityProviders();
                        }
                        SecureRandom secureRandom = ServiceManager.getService().getSecureRandom();
                        secureRandom.nextInt();
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        if (!Config.isJavaVersionAtLeast16()) {
                            trustManagerArray = new CertificateHostnameVerifier();
                            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)trustManagerArray);
                            object = new X509DeployTrustManager();
                        } else {
                            object = new X509ExtendedDeployTrustManager();
                        }
                        trustManagerArray = new TrustManager[]{object};
                        X509DeployKeyManager x509DeployKeyManager = new X509DeployKeyManager();
                        KeyManager[] keyManagerArray = new KeyManager[]{x509DeployKeyManager};
                        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
                        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
    }
}

