/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessImpl
extends Process {
    private static final char[] CMD_BAT_ESCAPE = new char[]{' ', '\t', '<', '>', '&', '|', '^'};
    private static final char[] WIN32_EXECUTABLE_ESCAPE = new char[]{' ', '\t', '<', '>'};
    private long handle = 0L;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;

    static Process start(String[] stringArray, Map<String, String> map, String string, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        return new ProcessImpl(stringArray, string2, string, bl);
    }

    private static boolean isQuoted(boolean bl, String string, String string2) {
        int n = string.length() - 1;
        if (n >= 1 && string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            if (bl && string.indexOf(34, 1) != n) {
                throw new IllegalArgumentException(string2);
            }
            return true;
        }
        if (bl && string.indexOf(34) >= 0) {
            throw new IllegalArgumentException(string2);
        }
        return false;
    }

    private static boolean needsEscaping(boolean bl, String string) {
        boolean bl2 = ProcessImpl.isQuoted(bl, string, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!bl2) {
            char[] cArray = bl ? CMD_BAT_ESCAPE : WIN32_EXECUTABLE_ESCAPE;
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String string) throws IOException {
        boolean bl = ProcessImpl.isQuoted(true, string, "Executable name has embedded quote, split the arguments");
        File file = new File(bl ? string.substring(1, string.length() - 1) : string);
        return file.getPath();
    }

    private ProcessImpl(String[] stringArray, String string, String string2, boolean bl) throws IOException {
        String string3 = ProcessImpl.getExecutablePath(stringArray[0]);
        String string4 = string3.toUpperCase();
        boolean bl2 = string4.endsWith(".CMD") || string4.endsWith(".BAT");
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append('\"');
        stringBuilder.append(string3);
        stringBuilder.append('\"');
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(' ');
            String string5 = stringArray[i];
            if (ProcessImpl.needsEscaping(bl2, string5)) {
                stringBuilder.append('\"');
                stringBuilder.append(string5);
                if (!bl2 && string5.endsWith("\\")) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string5);
        }
        String string6 = stringBuilder.toString();
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.handle = this.create(string6, string, string2, bl, this.stdin_fd, this.stdout_fd, this.stderr_fd);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(ProcessImpl.this.stdin_fd));
                ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(ProcessImpl.this.stdout_fd));
                ProcessImpl.this.stderr_stream = new FileInputStream(ProcessImpl.this.stderr_fd);
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public native int exitValue();

    @Override
    public native int waitFor();

    @Override
    public native void destroy();

    private native long create(String var1, String var2, String var3, boolean var4, FileDescriptor var5, FileDescriptor var6, FileDescriptor var7) throws IOException;

    private native void close();
}

