/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftProcess;
import com.sun.media.sound.SoftSynthesizer;

public class SoftEnvelopeGenerator
implements SoftProcess {
    public static final int EG_OFF = 0;
    public static final int EG_DELAY = 1;
    public static final int EG_ATTACK = 2;
    public static final int EG_HOLD = 3;
    public static final int EG_DECAY = 4;
    public static final int EG_SUSTAIN = 5;
    public static final int EG_RELEASE = 6;
    public static final int EG_SHUTDOWN = 7;
    public static final int EG_END = 8;
    int max_count = 10;
    int used_count = 0;
    private int[] stage = new int[this.max_count];
    private int[] stage_ix = new int[this.max_count];
    private double[] stage_v = new double[this.max_count];
    private int[] stage_count = new int[this.max_count];
    private double[][] on = new double[this.max_count][1];
    private double[][] active = new double[this.max_count][1];
    private double[][] out = new double[this.max_count][1];
    private double[][] delay = new double[this.max_count][1];
    private double[][] attack = new double[this.max_count][1];
    private double[][] hold = new double[this.max_count][1];
    private double[][] decay = new double[this.max_count][1];
    private double[][] sustain = new double[this.max_count][1];
    private double[][] release = new double[this.max_count][1];
    private double[][] shutdown = new double[this.max_count][1];
    private double[][] release2 = new double[this.max_count][1];
    private double[][] attack2 = new double[this.max_count][1];
    private double[][] decay2 = new double[this.max_count][1];
    private double control_time = 0.0;

    public void reset() {
        for (int i = 0; i < this.used_count; ++i) {
            this.stage[i] = 0;
            this.on[i][0] = 0.0;
            this.out[i][0] = 0.0;
            this.delay[i][0] = 0.0;
            this.attack[i][0] = 0.0;
            this.hold[i][0] = 0.0;
            this.decay[i][0] = 0.0;
            this.sustain[i][0] = 0.0;
            this.release[i][0] = 0.0;
            this.shutdown[i][0] = 0.0;
            this.attack2[i][0] = 0.0;
            this.decay2[i][0] = 0.0;
            this.release2[i][0] = 0.0;
        }
        this.used_count = 0;
    }

    public void init(SoftSynthesizer softSynthesizer) {
        this.control_time = 1.0 / (double)softSynthesizer.getControlRate();
        this.processControlLogic();
    }

    public double[] get(int n, String string) {
        if (n >= this.used_count) {
            this.used_count = n + 1;
        }
        if (string == null) {
            return this.out[n];
        }
        if (string.equals("on")) {
            return this.on[n];
        }
        if (string.equals("active")) {
            return this.active[n];
        }
        if (string.equals("delay")) {
            return this.delay[n];
        }
        if (string.equals("attack")) {
            return this.attack[n];
        }
        if (string.equals("hold")) {
            return this.hold[n];
        }
        if (string.equals("decay")) {
            return this.decay[n];
        }
        if (string.equals("sustain")) {
            return this.sustain[n];
        }
        if (string.equals("release")) {
            return this.release[n];
        }
        if (string.equals("shutdown")) {
            return this.shutdown[n];
        }
        if (string.equals("attack2")) {
            return this.attack2[n];
        }
        if (string.equals("decay2")) {
            return this.decay2[n];
        }
        if (string.equals("release2")) {
            return this.release2[n];
        }
        return null;
    }

    public void processControlLogic() {
        block10: for (int i = 0; i < this.used_count; ++i) {
            double d;
            if (this.stage[i] == 8) continue;
            if (this.stage[i] > 0 && this.stage[i] < 6 && this.on[i][0] < 0.5) {
                if (this.on[i][0] < -0.5) {
                    this.stage_count[i] = (int)(Math.pow(2.0, this.shutdown[i][0] / 1200.0) / this.control_time);
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_v[i] = this.out[i][0];
                    this.stage_ix[i] = 0;
                    this.stage[i] = 7;
                } else {
                    if (this.release2[i][0] < 1.0E-6 && this.release[i][0] < 0.0 && Double.isInfinite(this.release[i][0])) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue;
                    }
                    this.stage_count[i] = (int)(Math.pow(2.0, this.release[i][0] / 1200.0) / this.control_time);
                    int n = i;
                    this.stage_count[n] = this.stage_count[n] + (int)(this.release2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_ix[i] = 0;
                    d = 1.0 - this.out[i][0];
                    this.stage_ix[i] = (int)((double)this.stage_count[i] * d);
                    this.stage[i] = 6;
                }
            }
            switch (this.stage[i]) {
                case 0: {
                    this.active[i][0] = 1.0;
                    if (this.on[i][0] < 0.5) continue block10;
                    this.stage[i] = 1;
                    this.stage_ix[i] = (int)(Math.pow(2.0, this.delay[i][0] / 1200.0) / this.control_time);
                    if (this.stage_ix[i] < 0) {
                        this.stage_ix[i] = 0;
                    }
                }
                case 1: {
                    double d2;
                    if (this.stage_ix[i] == 0) {
                        d = this.attack[i][0];
                        d2 = this.attack2[i][0];
                        if (d2 < 1.0E-6 && d < 0.0 && Double.isInfinite(d)) {
                            this.out[i][0] = 1.0;
                            this.stage[i] = 3;
                            this.stage_count[i] = (int)(Math.pow(2.0, this.hold[i][0] / 1200.0) / this.control_time);
                            this.stage_ix[i] = 0;
                            continue block10;
                        }
                        this.stage[i] = 2;
                        this.stage_count[i] = (int)(Math.pow(2.0, d / 1200.0) / this.control_time);
                        int n = i;
                        this.stage_count[n] = this.stage_count[n] + (int)(d2 / (this.control_time * 1000.0));
                        if (this.stage_count[i] < 0) {
                            this.stage_count[i] = 0;
                        }
                        this.stage_ix[i] = 0;
                        continue block10;
                    }
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] - 1;
                    continue block10;
                }
                case 2: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 1.0;
                        this.stage[i] = 3;
                        continue block10;
                    }
                    d = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    d = 1.0 + 0.4166666666666667 / Math.log(10.0) * Math.log(d);
                    if (d < 0.0) {
                        d = 0.0;
                    } else if (d > 1.0) {
                        d = 1.0;
                    }
                    this.out[i][0] = d;
                    continue block10;
                }
                case 3: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] < this.stage_count[i]) continue block10;
                    this.stage[i] = 4;
                    this.stage_count[i] = (int)(Math.pow(2.0, this.decay[i][0] / 1200.0) / this.control_time);
                    int n2 = i;
                    this.stage_count[n2] = this.stage_count[n2] + (int)(this.decay2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    this.stage_ix[i] = 0;
                    continue block10;
                }
                case 4: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    d = this.sustain[i][0] * 0.001;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = d;
                        this.stage[i] = 5;
                        if (!(d < 0.001)) continue block10;
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double d2 = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = 1.0 - d2 + d * d2;
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double d2 = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = 1.0 - d2;
                    if (this.on[i][0] < -0.5) {
                        this.stage_count[i] = (int)(Math.pow(2.0, this.shutdown[i][0] / 1200.0) / this.control_time);
                        if (this.stage_count[i] < 0) {
                            this.stage_count[i] = 0;
                        }
                        this.stage_v[i] = this.out[i][0];
                        this.stage_ix[i] = 0;
                        this.stage[i] = 7;
                    }
                    if (!(this.on[i][0] > 0.5) || !(this.out[i][0] > (d = this.sustain[i][0] * 0.001))) continue block10;
                    this.stage[i] = 4;
                    this.stage_count[i] = (int)(Math.pow(2.0, this.decay[i][0] / 1200.0) / this.control_time);
                    int n3 = i;
                    this.stage_count[n3] = this.stage_count[n3] + (int)(this.decay2[i][0] / (this.control_time * 1000.0));
                    if (this.stage_count[i] < 0) {
                        this.stage_count[i] = 0;
                    }
                    d2 = (this.out[i][0] - 1.0) / (d - 1.0);
                    this.stage_ix[i] = (int)((double)this.stage_count[i] * d2);
                    continue block10;
                }
                case 7: {
                    int n = i;
                    this.stage_ix[n] = this.stage_ix[n] + 1;
                    if (this.stage_ix[i] >= this.stage_count[i]) {
                        this.out[i][0] = 0.0;
                        this.active[i][0] = 0.0;
                        this.stage[i] = 8;
                        continue block10;
                    }
                    double d2 = (double)this.stage_ix[i] / (double)this.stage_count[i];
                    this.out[i][0] = (1.0 - d2) * this.stage_v[i];
                    continue block10;
                }
            }
        }
    }
}

