/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import sun.plugin2.main.server.JVMHealthData;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.PluginMessage;
import sun.plugin2.message.Serializer;

public class HeartbeatMessage
extends PluginMessage {
    public static final int ID = 15;
    public static final long DEFAULT_INTERVAL = 1000L;
    public static final long DEFAULT_TIMEOUT = 10000L;
    private static long INTERVAL_TIMEOUT_SAFETY = 1000L;
    private static long MINIMAL_TIMEOUT = 2000L;
    private JVMHealthData healthData;
    private long timeout = 10000L;
    private long interval = 1000L;

    public HeartbeatMessage(Conversation conversation) {
        this(conversation, new JVMHealthData());
    }

    public HeartbeatMessage(Conversation conversation, JVMHealthData jVMHealthData) {
        super(15, conversation);
        this.healthData = jVMHealthData;
    }

    public void updateHealthData() {
        this.healthData = JVMHealthData.getCurrent();
    }

    public JVMHealthData getHealthData() {
        return this.healthData;
    }

    public void adjustTiming(long l, long l2) {
        if (l2 < MINIMAL_TIMEOUT) {
            l2 = MINIMAL_TIMEOUT;
        }
        this.interval = l > this.timeout - INTERVAL_TIMEOUT_SAFETY ? this.timeout - INTERVAL_TIMEOUT_SAFETY : l;
        this.timeout = l2 < this.interval + INTERVAL_TIMEOUT_SAFETY ? this.interval + INTERVAL_TIMEOUT_SAFETY : l2;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void writeFields(Serializer serializer) throws IOException {
        HeartbeatMessage.writeJVMHealthData(serializer, this.healthData);
        serializer.writeLong(this.timeout);
        serializer.writeLong(this.interval);
    }

    public void readFields(Serializer serializer) throws IOException {
        this.healthData = HeartbeatMessage.readJVMHealthData(serializer);
        this.timeout = serializer.readLong();
        this.interval = serializer.readLong();
    }

    static void writeJVMHealthData(Serializer serializer, JVMHealthData jVMHealthData) throws IOException {
        long l = jVMHealthData == null ? -1L : jVMHealthData.getMaxHeapSize();
        long l2 = jVMHealthData == null ? -1L : jVMHealthData.getHeapSize();
        long l3 = jVMHealthData == null ? -1L : jVMHealthData.getFreeHeapSize();
        int n = jVMHealthData == null ? -1 : jVMHealthData.getAppletThreadCount();
        serializer.writeLong(l);
        serializer.writeLong(l2);
        serializer.writeLong(l3);
        serializer.writeInt(n);
    }

    static JVMHealthData readJVMHealthData(Serializer serializer) throws IOException {
        long l = serializer.readLong();
        long l2 = serializer.readLong();
        long l3 = serializer.readLong();
        int n = serializer.readInt();
        return new JVMHealthData(l, l2, l3, n);
    }

    public String toString() {
        String string = this.getConversation() + " ";
        return string + (this.healthData == null ? "{healthData: null }" : this.healthData.toString());
    }
}

