/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import sun.misc.Unsafe;

public class LockSupport {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long parkBlockerOffset;

    private LockSupport() {
    }

    private static void setBlocker(Thread thread, Object object) {
        unsafe.putObject((Object)thread, parkBlockerOffset, object);
    }

    public static void unpark(Thread thread) {
        if (thread != null) {
            unsafe.unpark(thread);
        }
    }

    public static void park(Object object) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        unsafe.park(false, 0L);
        LockSupport.setBlocker(thread, null);
    }

    public static void parkNanos(Object object, long l) {
        if (l > 0L) {
            Thread thread = Thread.currentThread();
            LockSupport.setBlocker(thread, object);
            unsafe.park(false, l);
            LockSupport.setBlocker(thread, null);
        }
    }

    public static void parkUntil(Object object, long l) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        unsafe.park(true, l);
        LockSupport.setBlocker(thread, null);
    }

    public static Object getBlocker(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        return unsafe.getObjectVolatile(thread, parkBlockerOffset);
    }

    public static void park() {
        unsafe.park(false, 0L);
    }

    public static void parkNanos(long l) {
        if (l > 0L) {
            unsafe.park(false, l);
        }
    }

    public static void parkUntil(long l) {
        unsafe.park(true, l);
    }

    static {
        try {
            parkBlockerOffset = unsafe.objectFieldOffset(Thread.class.getDeclaredField("parkBlocker"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

