/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

final class EPRHeader
extends AbstractHeaderImpl {
    private final String nsUri;
    private final String localName;
    private final WSEndpointReference epr;

    EPRHeader(QName qName, WSEndpointReference wSEndpointReference) {
        this.nsUri = qName.getNamespaceURI();
        this.localName = qName.getLocalPart();
        this.epr = wSEndpointReference;
    }

    @NotNull
    public String getNamespaceURI() {
        return this.nsUri;
    }

    @NotNull
    public String getLocalPart() {
        return this.localName;
    }

    @Nullable
    public String getAttribute(@NotNull String string, @NotNull String string2) {
        try {
            XMLStreamReader xMLStreamReader = this.epr.read("EndpointReference");
            while (xMLStreamReader.getEventType() != 1) {
                xMLStreamReader.next();
            }
            return xMLStreamReader.getAttributeValue(string, string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.epr.read(this.localName);
    }

    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.epr.writeTo(this.localName, xMLStreamWriter);
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        try {
            Transformer transformer = XmlUtil.newTransformer();
            transformer.transform(this.epr.asSource(this.localName), new DOMResult(sOAPMessage.getSOAPHeader()));
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.epr.writeTo(this.localName, contentHandler, errorHandler, true);
    }
}

