/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.Security;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Provider
extends java.security.Provider {
    private static final long serialVersionUID = 3231825739635378733L;
    private static String info = "Sun JSSE provider(PKCS12, SunX509 key/trust factories, SSLv3, TLSv1)";
    private static String fipsInfo = "Sun JSSE provider (FIPS mode, crypto provider ";
    private static Boolean fips;
    static java.security.Provider cryptoProvider;

    public static synchronized void install() {
    }

    public static synchronized boolean isFIPS() {
        if (fips == null) {
            fips = false;
        }
        return fips;
    }

    private static synchronized void ensureFIPS(java.security.Provider provider) {
        if (fips == null) {
            fips = true;
            cryptoProvider = provider;
        } else {
            if (!fips.booleanValue()) {
                throw new ProviderException("SunJSSE already initialized in non-FIPS mode");
            }
            if (cryptoProvider != provider) {
                throw new ProviderException("SunJSSE already initialized with FIPS crypto provider " + cryptoProvider);
            }
        }
    }

    public Provider() {
        super("SunJSSE", 1.6, info);
        if (Boolean.TRUE.equals(fips)) {
            throw new ProviderException("SunJSSE is already initialized in FIPS mode");
        }
        this.registerAlgorithms(false);
    }

    public Provider(java.security.Provider provider) {
        this(Provider.checkNull(provider), provider.getName());
    }

    public Provider(String string) {
        this(null, Provider.checkNull(string));
    }

    private static <T> T checkNull(T t) {
        if (t == null) {
            throw new ProviderException("cryptoProvider must not be null");
        }
        return t;
    }

    private Provider(java.security.Provider provider, String string) {
        super("SunJSSE", 1.6, fipsInfo + string + ")");
        if (provider == null && (provider = Security.getProvider(string)) == null) {
            throw new ProviderException("Crypto provider not installed: " + string);
        }
        Provider.ensureFIPS(provider);
        this.registerAlgorithms(true);
    }

    private void registerAlgorithms(final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Provider.this.doRegister(bl);
                return null;
            }
        });
    }

    private void doRegister(boolean bl) {
        if (!bl) {
            this.put("KeyFactory.RSA", "sun.security.rsa.RSAKeyFactory");
            this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1", "RSA");
            this.put("Alg.Alias.KeyFactory.OID.1.2.840.113549.1.1", "RSA");
            this.put("KeyPairGenerator.RSA", "sun.security.rsa.RSAKeyPairGenerator");
            this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1", "RSA");
            this.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.113549.1.1", "RSA");
            this.put("Signature.MD2withRSA", "sun.security.rsa.RSASignature$MD2withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.2", "MD2withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.2", "MD2withRSA");
            this.put("Signature.MD5withRSA", "sun.security.rsa.RSASignature$MD5withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
            this.put("Signature.SHA1withRSA", "sun.security.rsa.RSASignature$SHA1withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
            this.put("Alg.Alias.Signature.1.3.14.3.2.29", "SHA1withRSA");
            this.put("Alg.Alias.Signature.OID.1.3.14.3.2.29", "SHA1withRSA");
        }
        this.put("Signature.MD5andSHA1withRSA", "com.sun.net.ssl.internal.ssl.RSASignature");
        this.put("KeyManagerFactory.SunX509", "com.sun.net.ssl.internal.ssl.KeyManagerFactoryImpl$SunX509");
        this.put("KeyManagerFactory.NewSunX509", "com.sun.net.ssl.internal.ssl.KeyManagerFactoryImpl$X509");
        this.put("TrustManagerFactory.SunX509", "com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl$SimpleFactory");
        this.put("TrustManagerFactory.PKIX", "com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl$PKIXFactory");
        this.put("Alg.Alias.TrustManagerFactory.SunPKIX", "PKIX");
        this.put("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.put("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        if (!bl) {
            this.put("SSLContext.SSL", "com.sun.net.ssl.internal.ssl.SSLContextImpl");
            this.put("SSLContext.SSLv3", "com.sun.net.ssl.internal.ssl.SSLContextImpl");
        }
        this.put("SSLContext.TLS", "com.sun.net.ssl.internal.ssl.SSLContextImpl");
        this.put("SSLContext.TLSv1", "com.sun.net.ssl.internal.ssl.SSLContextImpl");
        this.put("SSLContext.Default", "com.sun.net.ssl.internal.ssl.DefaultSSLContextImpl");
        this.put("KeyStore.PKCS12", "com.sun.net.ssl.internal.pkcs12.PKCS12KeyStore");
    }
}

