/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

class EngineArgs {
    ByteBuffer netData;
    ByteBuffer[] appData;
    private int offset;
    private int len;
    private int netPos;
    private int netLim;
    private int[] appPoss;
    private int[] appLims;
    private int appRemaining = 0;
    private boolean wrapMethod;

    EngineArgs(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) {
        this.wrapMethod = true;
        this.init(byteBuffer, byteBufferArray, n, n2);
    }

    EngineArgs(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) {
        this.wrapMethod = false;
        this.init(byteBuffer, byteBufferArray, n, n2);
    }

    private void init(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) {
        if (byteBuffer == null || byteBufferArray == null) {
            throw new IllegalArgumentException("src/dst is null");
        }
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.wrapMethod && byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.netPos = byteBuffer.position();
        this.netLim = byteBuffer.limit();
        this.appPoss = new int[byteBufferArray.length];
        this.appLims = new int[byteBufferArray.length];
        for (int i = n; i < n + n2; ++i) {
            if (byteBufferArray[i] == null) {
                throw new IllegalArgumentException("appData[" + i + "] == null");
            }
            if (!this.wrapMethod && byteBufferArray[i].isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            this.appRemaining += byteBufferArray[i].remaining();
            this.appPoss[i] = byteBufferArray[i].position();
            this.appLims[i] = byteBufferArray[i].limit();
        }
        this.netData = byteBuffer;
        this.appData = byteBufferArray;
        this.offset = n;
        this.len = n2;
    }

    void gather(int n) {
        int n2;
        for (int i = this.offset; i < this.offset + this.len && n > 0; n -= n2, ++i) {
            n2 = Math.min(this.appData[i].remaining(), n);
            this.appData[i].limit(this.appData[i].position() + n2);
            this.netData.put(this.appData[i]);
            this.appRemaining -= n2;
        }
    }

    void scatter(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        for (int i = this.offset; i < this.offset + this.len && n2 > 0; n2 -= n, ++i) {
            n = Math.min(this.appData[i].remaining(), n2);
            byteBuffer.limit(byteBuffer.position() + n);
            this.appData[i].put(byteBuffer);
        }
        assert (byteBuffer.remaining() == 0);
    }

    int getAppRemaining() {
        return this.appRemaining;
    }

    int deltaNet() {
        return this.netData.position() - this.netPos;
    }

    int deltaApp() {
        int n = 0;
        for (int i = this.offset; i < this.offset + this.len; ++i) {
            n += this.appData[i].position() - this.appPoss[i];
        }
        return n;
    }

    void resetPos() {
        this.netData.position(this.netPos);
        for (int i = this.offset; i < this.offset + this.len; ++i) {
            this.appData[i].position(this.appPoss[i]);
        }
    }

    void resetLim() {
        this.netData.limit(this.netLim);
        for (int i = this.offset; i < this.offset + this.len; ++i) {
            this.appData[i].limit(this.appLims[i]);
        }
    }
}

