/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private int blockSize;
    private final boolean isCBCMode;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
        this.isCBCMode = false;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, boolean bl) throws NoSuchAlgorithmException {
        try {
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int n = bl ? 1 : 2;
            this.isCBCMode = bulkCipher.isCBCMode;
            this.cipher.init(n, (Key)secretKey, ivParameterSpec);
            this.blockSize = this.cipher.getBlockSize();
            if (this.blockSize == 1) {
                this.blockSize = 0;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exceptionInInitializerError);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, boolean bl) throws NoSuchAlgorithmException {
        if (!bulkCipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + bulkCipher);
        }
        if (bulkCipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(protocolVersion, bulkCipher, secretKey, ivParameterSpec, bl);
    }

    int encrypt(byte[] byArray, int n, int n2) {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3;
            if (this.blockSize != 0) {
                n2 = CipherBox.addPadding(byArray, n, n2, this.blockSize);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n2);
                    hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((n3 = this.cipher.update(byArray, n, n2, byArray, n)) != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int encrypt(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n;
        }
        try {
            ByteBuffer byteBuffer2;
            int n2 = byteBuffer.position();
            if (this.blockSize != 0) {
                n = CipherBox.addPadding(byteBuffer, this.blockSize);
                byteBuffer.position(n2);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    byteBuffer2 = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n);
                    byteBuffer2.encodeBuffer(byteBuffer, System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byteBuffer.position(n2);
            }
            byteBuffer2 = byteBuffer.duplicate();
            int n3 = this.cipher.update(byteBuffer2, byteBuffer);
            if (byteBuffer.position() != byteBuffer2.position()) {
                throw new RuntimeException("bytebuffer padding error");
            }
            if (n3 != n) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    int decrypt(byte[] byArray, int n, int n2, int n3) throws BadPaddingException {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n4 = this.cipher.update(byArray, n, n2, byArray, n);
            if (n4 != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n4);
                    hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n4), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                n4 = CipherBox.removePadding(byArray, n, n4, n3, this.blockSize, this.protocolVersion);
            }
            return n4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int decrypt(ByteBuffer byteBuffer, int n) throws BadPaddingException {
        int n2 = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n2;
        }
        try {
            int n3 = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            int n4 = this.cipher.update(byteBuffer2, byteBuffer);
            if (n4 != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n4);
                    hexDumpEncoder.encodeBuffer((ByteBuffer)byteBuffer.duplicate().position(n3), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                byteBuffer.position(n3);
                n4 = CipherBox.removePadding(byteBuffer, n, this.blockSize, this.protocolVersion);
            }
            return n4;
        }
        catch (ShortBufferException shortBufferException) {
            RuntimeException runtimeException = new RuntimeException(shortBufferException.toString());
            runtimeException.initCause(shortBufferException);
            throw runtimeException;
        }
    }

    private static int addPadding(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + 1;
        if (n4 % n3 != 0) {
            n4 += n3 - 1;
            n4 -= n4 % n3;
        }
        int n5 = n4 - n2;
        if (byArray.length < n4 + n) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        n += n2;
        for (int i = 0; i < n5; ++i) {
            byArray[n++] = (byte)(n5 - 1);
        }
        return n4;
    }

    private static int addPadding(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = n2 + 1;
        if (n4 % n != 0) {
            n4 += n - 1;
            n4 -= n4 % n;
        }
        int n5 = n4 - n2;
        byteBuffer.limit(n4 + n3);
        n3 += n2;
        for (int i = 0; i < n5; ++i) {
            byteBuffer.put(n3++, (byte)(n5 - 1));
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n3);
        return n4;
    }

    private static int[] checkPadding(byte[] byArray, int n, int n2, byte by) {
        if (n2 <= 0) {
            throw new RuntimeException("padding len must be positive");
        }
        int[] nArray = new int[]{0, 0};
        int n3 = 0;
        while (n3 <= 256) {
            for (int i = 0; i < n2 && n3 <= 256; ++i, ++n3) {
                if (byArray[n + i] != by) {
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                nArray[1] = nArray[1] + 1;
            }
        }
        return nArray;
    }

    private static int[] checkPadding(ByteBuffer byteBuffer, byte by) {
        if (!byteBuffer.hasRemaining()) {
            throw new RuntimeException("hasRemaining() must be positive");
        }
        int[] nArray = new int[]{0, 0};
        byteBuffer.mark();
        int n = 0;
        while (n <= 256) {
            while (byteBuffer.hasRemaining() && n <= 256) {
                if (byteBuffer.get() != by) {
                    nArray[0] = nArray[0] + 1;
                } else {
                    nArray[1] = nArray[1] + 1;
                }
                ++n;
            }
            byteBuffer.reset();
        }
        return nArray;
    }

    private static int removePadding(byte[] byArray, int n, int n2, int n3, int n4, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n5 = n + n2 - 1;
        int n6 = byArray[n5] & 0xFF;
        int n7 = n2 - (n6 + 1);
        if (n7 - n3 < 0) {
            CipherBox.checkPadding(byArray, n, n2, (byte)(n6 & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + n6);
        }
        int[] nArray = CipherBox.checkPadding(byArray, n + n7, n6 + 1, (byte)(n6 & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (nArray[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (n6 > n4) {
            throw new BadPaddingException("Invalid SSLv3 padding");
        }
        return n7;
    }

    private static int removePadding(ByteBuffer byteBuffer, int n, int n2, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n3;
        int n4;
        int n5;
        int n6 = byteBuffer.remaining();
        int n7 = n6 - ((n5 = byteBuffer.get(n4 = (n3 = byteBuffer.position()) + n6 - 1) & 0xFF) + 1);
        if (n7 - n < 0) {
            CipherBox.checkPadding(byteBuffer.duplicate(), (byte)(n5 & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + n5);
        }
        int[] nArray = CipherBox.checkPadding((ByteBuffer)byteBuffer.duplicate().position(n3 + n7), (byte)(n5 & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (nArray[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (n5 > n2) {
            throw new BadPaddingException("Invalid SSLv3 padding");
        }
        byteBuffer.position(n3 + n7);
        byteBuffer.limit(n3 + n7);
        return n7;
    }

    void dispose() {
        try {
            if (this.cipher != null) {
                this.cipher.doFinal();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    boolean isCBCMode() {
        return this.isCBCMode;
    }

    boolean isNullCipher() {
        return this.cipher == null;
    }

    boolean sanityCheck(int n, int n2) {
        if (!this.isCBCMode) {
            return n2 >= n;
        }
        if (n2 % this.blockSize == 0) {
            int n3 = n + 1;
            n3 = n3 >= this.blockSize ? n3 : this.blockSize;
            return n2 >= n3;
        }
        return false;
    }
}

