/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.UUID;
import sun.security.action.GetPropertyAction;
import sun.security.mscapi.Key;
import sun.security.mscapi.RSAPrivateKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class KeyStore
extends KeyStoreSpi {
    private CertificateFactory certificateFactory = null;
    private static final String KEYSTORE_COMPATIBILITY_MODE_PROP = "sun.security.mscapi.keyStoreCompatibilityMode";
    private final boolean keyStoreCompatibilityMode;
    private Collection<KeyEntry> entries = new ArrayList<KeyEntry>();
    private final String storeName;

    KeyStore(String string) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(KEYSTORE_COMPATIBILITY_MODE_PROP));
        this.keyStoreCompatibilityMode = !"false".equalsIgnoreCase(string2);
        this.storeName = string;
    }

    @Override
    public java.security.Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            return null;
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new UnrecoverableKeyException("Password must be null");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        for (KeyEntry keyEntry : this.entries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            return keyEntry.getPrivateKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        for (KeyEntry keyEntry : this.entries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            return (Certificate[])x509CertificateArray.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            return null;
        }
        for (KeyEntry keyEntry : this.entries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            return x509CertificateArray[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (string == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String string, java.security.Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new KeyStoreException("Password must be null");
        }
        if (key instanceof RSAPrivateCrtKey) {
            KeyEntry keyEntry = null;
            boolean bl = false;
            for (KeyEntry keyEntry2 : this.entries) {
                if (!string.equals(keyEntry2.getAlias())) continue;
                bl = true;
                keyEntry = keyEntry2;
                break;
            }
            if (!bl) {
                keyEntry = new KeyEntry(string, null, (X509Certificate[])certificateArray);
                this.entries.add(keyEntry);
            }
            keyEntry.setAlias(string);
            try {
                keyEntry.setPrivateKey((RSAPrivateCrtKey)key);
                keyEntry.setCertificateChain((X509Certificate[])certificateArray);
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyStoreException(invalidKeyException);
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the key to the given alias.");
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException("Cannot assign the encoded key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{(X509Certificate)certificate};
            KeyEntry keyEntry = null;
            boolean bl = false;
            for (KeyEntry keyEntry2 : this.entries) {
                if (!string.equals(keyEntry2.getAlias())) continue;
                bl = true;
                keyEntry = keyEntry2;
                break;
            }
            if (!bl) {
                keyEntry = new KeyEntry(string, null, x509CertificateArray);
                this.entries.add(keyEntry);
            }
            if (keyEntry.getPrivateKey() == null) {
                keyEntry.setAlias(string);
                try {
                    keyEntry.setCertificateChain(x509CertificateArray);
                }
                catch (CertificateException certificateException) {
                    throw new KeyStoreException(certificateException);
                }
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the certificate to the given alias.");
        }
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        for (KeyEntry keyEntry : this.entries) {
            Object object;
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            if (x509CertificateArray != null) {
                try {
                    object = x509CertificateArray[0].getEncoded();
                    this.removeCertificate(this.getName(), string, (byte[])object, ((Object)object).length);
                }
                catch (CertificateException certificateException) {
                    throw new KeyStoreException("Cannot remove entry: " + certificateException);
                }
            }
            if ((object = keyEntry.getPrivateKey()) != null) {
                this.destroyKeyContainer(Key.getContainerName(((Key)object).getHCryptProvider()));
            }
            this.entries.remove(keyEntry);
            break;
        }
    }

    public Enumeration engineAliases() {
        final Iterator<KeyEntry> iterator = this.entries.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                KeyEntry keyEntry = (KeyEntry)iterator.next();
                return keyEntry.getAlias();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String string) {
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        if (string == null) {
            return false;
        }
        for (KeyEntry keyEntry : this.entries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            return keyEntry.getPrivateKey() != null;
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        for (KeyEntry keyEntry : this.entries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            return keyEntry.getPrivateKey() == null;
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        for (KeyEntry keyEntry : this.entries) {
            if (keyEntry.certChain == null || !keyEntry.certChain[0].equals(certificate)) continue;
            return keyEntry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (outputStream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore output stream must be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore input stream must be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider.SunMSCAPI"));
        }
        this.entries.clear();
        try {
            this.loadKeysOrCertificateChains(this.getName(), this.entries);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
    }

    private void generateCertificateChain(String string, Collection collection, Collection<KeyEntry> collection2) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n = 0;
            Object object = collection.iterator();
            while (object.hasNext()) {
                x509CertificateArray[n] = (X509Certificate)object.next();
                ++n;
            }
            object = new KeyEntry(string, null, x509CertificateArray);
            collection2.add((KeyEntry)object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateRSAKeyAndCertificateChain(String string, long l, long l2, int n, Collection collection, Collection<KeyEntry> collection2) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n2 = 0;
            Object object = collection.iterator();
            while (object.hasNext()) {
                x509CertificateArray[n2] = (X509Certificate)object.next();
                ++n2;
            }
            object = new KeyEntry(string, new RSAPrivateKey(l, l2, n), x509CertificateArray);
            collection2.add((KeyEntry)object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateCertificate(byte[] byArray, Collection collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (this.certificateFactory == null) {
                this.certificateFactory = CertificateFactory.getInstance("X.509");
            }
            Collection<? extends Certificate> collection2 = this.certificateFactory.generateCertificates(byteArrayInputStream);
            collection.addAll(collection2);
        }
        catch (CertificateException certificateException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getName() {
        return this.storeName;
    }

    private native void loadKeysOrCertificateChains(String var1, Collection<KeyEntry> var2) throws KeyStoreException;

    private native void storeCertificate(String var1, String var2, byte[] var3, int var4, long var5, long var7) throws CertificateException, KeyStoreException;

    private native void removeCertificate(String var1, String var2, byte[] var3, int var4) throws CertificateException, KeyStoreException;

    private native void destroyKeyContainer(String var1) throws KeyStoreException;

    private native byte[] generatePrivateKeyBlob(int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9) throws InvalidKeyException;

    private native RSAPrivateKey storePrivateKey(byte[] var1, String var2, int var3) throws KeyStoreException;

    class KeyEntry {
        private Key privateKey;
        private X509Certificate[] certChain;
        private String alias;

        KeyEntry(Key key, X509Certificate[] x509CertificateArray) {
            this(null, key, x509CertificateArray);
        }

        KeyEntry(String string, Key key, X509Certificate[] x509CertificateArray) {
            this.privateKey = key;
            this.certChain = x509CertificateArray;
            this.alias = string == null ? Integer.toString(x509CertificateArray[0].hashCode()) : string;
        }

        String getAlias() {
            return this.alias;
        }

        void setAlias(String string) {
            this.alias = string;
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        void setPrivateKey(RSAPrivateCrtKey rSAPrivateCrtKey) throws InvalidKeyException, KeyStoreException {
            byte[] byArray = rSAPrivateCrtKey.getModulus().toByteArray();
            int n = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
            byte[] byArray2 = KeyStore.this.generatePrivateKeyBlob(n, byArray, rSAPrivateCrtKey.getPublicExponent().toByteArray(), rSAPrivateCrtKey.getPrivateExponent().toByteArray(), rSAPrivateCrtKey.getPrimeP().toByteArray(), rSAPrivateCrtKey.getPrimeQ().toByteArray(), rSAPrivateCrtKey.getPrimeExponentP().toByteArray(), rSAPrivateCrtKey.getPrimeExponentQ().toByteArray(), rSAPrivateCrtKey.getCrtCoefficient().toByteArray());
            this.privateKey = KeyStore.this.storePrivateKey(byArray2, "{" + UUID.randomUUID().toString() + "}", n);
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }

        void setCertificateChain(X509Certificate[] x509CertificateArray) throws CertificateException, KeyStoreException {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                if (i == 0 && this.privateKey != null) {
                    KeyStore.this.storeCertificate(KeyStore.this.getName(), this.alias, byArray, byArray.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
                    continue;
                }
                KeyStore.this.storeCertificate(KeyStore.this.getName(), this.alias, byArray, byArray.length, 0L, 0L);
            }
            this.certChain = x509CertificateArray;
        }
    }

    public static final class ROOT
    extends KeyStore {
        public ROOT() {
            super("ROOT");
        }
    }

    public static final class MY
    extends KeyStore {
        public MY() {
            super("MY");
        }
    }
}

