/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.awt.AWTUtilities;
import com.sun.java.swing.SwingUtilities3;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.image.VolatileImage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BufferStrategyPaintManager;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepaintManager {
    static final boolean HANDLE_TOP_LEVEL_PAINT;
    private static final short BUFFER_STRATEGY_NOT_SPECIFIED = 0;
    private static final short BUFFER_STRATEGY_SPECIFIED_ON = 1;
    private static final short BUFFER_STRATEGY_SPECIFIED_OFF = 2;
    private static final short BUFFER_STRATEGY_TYPE;
    private Map<GraphicsConfiguration, VolatileImage> volatileMap = new HashMap<GraphicsConfiguration, VolatileImage>(1);
    private Map<Container, Rectangle> hwDirtyComponents;
    private Map<Component, Rectangle> dirtyComponents;
    private Map<Component, Rectangle> tmpDirtyComponents;
    private List<Component> invalidComponents;
    private List<Runnable> runnableList;
    boolean doubleBufferingEnabled = true;
    private Dimension doubleBufferMaxSize;
    DoubleBufferInfo standardDoubleBuffer;
    private PaintManager paintManager;
    private static final Object repaintManagerKey;
    static boolean volatileImageBufferEnabled;
    private static boolean nativeDoubleBuffering;
    private static final int VOLATILE_LOOP_MAX = 2;
    private int paintDepth = 0;
    private short bufferStrategyType;
    private boolean painting;
    private JComponent repaintRoot;
    private Thread paintThread;
    private final ProcessingRunnable processingRunnable;
    private static final JavaSecurityAccess javaSecurityAccess;
    Rectangle tmp = new Rectangle();

    public static RepaintManager currentManager(Component component) {
        return RepaintManager.currentManager(AppContext.getAppContext());
    }

    static RepaintManager currentManager(AppContext appContext) {
        RepaintManager repaintManager = (RepaintManager)appContext.get(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager(BUFFER_STRATEGY_TYPE);
            appContext.put(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        } else {
            SwingUtilities.appContextRemove(repaintManagerKey);
        }
    }

    public RepaintManager() {
        this(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepaintManager(short s) {
        this.doubleBufferingEnabled = !nativeDoubleBuffering;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents = new IdentityHashMap<Component, Rectangle>();
            this.tmpDirtyComponents = new IdentityHashMap<Component, Rectangle>();
            this.bufferStrategyType = s;
            this.hwDirtyComponents = new IdentityHashMap<Container, Rectangle>();
        }
        this.processingRunnable = new ProcessingRunnable();
    }

    private void displayChanged() {
        this.clearImages();
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component;
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            repaintManager.addInvalidComponent(jComponent);
            return;
        }
        Component component2 = null;
        for (component = jComponent; component != null; component = component.getParent()) {
            if (component instanceof CellRendererPane || component.getPeer() == null) {
                return;
            }
            if (!(component instanceof JComponent) || !component.isValidateRoot()) continue;
            component2 = component;
            break;
        }
        if (component2 == null) {
            return;
        }
        component = null;
        for (Component component3 = component2; component3 != null; component3 = component3.getParent()) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (!(component3 instanceof Window) && !(component3 instanceof Applet)) continue;
            component = component3;
            break;
        }
        if (component == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new ArrayList<Component>();
        } else {
            int n = this.invalidComponents.size();
            for (int i = 0; i < n; ++i) {
                if (component2 != this.invalidComponents.get(i)) continue;
                return;
            }
        }
        this.invalidComponents.add(component2);
        this.scheduleProcessingRunnable();
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n;
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            repaintManager.removeInvalidComponent(jComponent);
            return;
        }
        if (this.invalidComponents != null && (n = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirtyRegion0(Container container, int n, int n2, int n3, int n4) {
        Object object;
        if (n3 <= 0 || n4 <= 0 || container == null) {
            return;
        }
        if (container.getWidth() <= 0 || container.getHeight() <= 0) {
            return;
        }
        if (this.extendDirtyRegion(container, n, n2, n3, n4)) {
            return;
        }
        Object object2 = null;
        for (object = container; object != null; object = ((Component)object).getParent()) {
            if (!((Component)object).isVisible() || ((Component)object).getPeer() == null) {
                return;
            }
            if (!(object instanceof Window) && !(object instanceof Applet)) continue;
            if (object instanceof Frame && (((Frame)object).getExtendedState() & 1) == 1) {
                return;
            }
            object2 = object;
            break;
        }
        if (object2 == null) {
            return;
        }
        object = this;
        synchronized (object) {
            if (this.extendDirtyRegion(container, n, n2, n3, n4)) {
                return;
            }
            this.dirtyComponents.put(container, new Rectangle(n, n2, n3, n4));
        }
        this.scheduleProcessingRunnable();
    }

    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            repaintManager.addDirtyRegion(jComponent, n, n2, n3, n4);
            return;
        }
        this.addDirtyRegion0(jComponent, n, n2, n3, n4);
    }

    public void addDirtyRegion(Window window, int n, int n2, int n3, int n4) {
        this.addDirtyRegion0(window, n, n2, n3, n4);
    }

    public void addDirtyRegion(Applet applet, int n, int n2, int n3, int n4) {
        this.addDirtyRegion0(applet, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleHeavyWeightPaints() {
        Map<Container, Rectangle> map;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.hwDirtyComponents.size() == 0) {
                return;
            }
            map = this.hwDirtyComponents;
            this.hwDirtyComponents = new IdentityHashMap<Container, Rectangle>();
        }
        for (Container container : map.keySet()) {
            Rectangle rectangle = map.get(container);
            if (container instanceof Window) {
                this.addDirtyRegion((Window)container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                continue;
            }
            if (container instanceof Applet) {
                this.addDirtyRegion((Applet)container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                continue;
            }
            this.addDirtyRegion0(container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nativeAddDirtyRegion(AppContext appContext, Container container, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            RepaintManager repaintManager = this;
            synchronized (repaintManager) {
                Rectangle rectangle = this.hwDirtyComponents.get(container);
                if (rectangle == null) {
                    this.hwDirtyComponents.put(container, new Rectangle(n, n2, n3, n4));
                } else {
                    this.hwDirtyComponents.put(container, SwingUtilities.computeUnion(n, n2, n3, n4, rectangle));
                }
            }
            this.scheduleProcessingRunnable(appContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nativeQueueSurfaceDataRunnable(AppContext appContext, final Component component, final Runnable runnable) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.runnableList == null) {
                this.runnableList = new LinkedList<Runnable>();
            }
            this.runnableList.add(new Runnable(){

                public void run() {
                    AccessControlContext accessControlContext = AccessController.getContext();
                    AccessControlContext accessControlContext2 = AWTAccessor.getComponentAccessor().getAccessControlContext(component);
                    javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            runnable.run();
                            return null;
                        }
                    }, accessControlContext, accessControlContext2);
                }
            });
        }
        this.scheduleProcessingRunnable(appContext);
    }

    private synchronized boolean extendDirtyRegion(Component component, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.dirtyComponents.get(component);
        if (rectangle != null) {
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getDirtyRegion(JComponent jComponent) {
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            return repaintManager.getDirtyRegion(jComponent);
        }
        Rectangle rectangle = null;
        RepaintManager repaintManager2 = this;
        synchronized (repaintManager2) {
            rectangle = this.dirtyComponents.get(jComponent);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public void markCompletelyDirty(JComponent jComponent) {
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            repaintManager.markCompletelyDirty(jComponent);
            return;
        }
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            repaintManager.markCompletelyClean(jComponent);
            return;
        }
        RepaintManager repaintManager2 = this;
        synchronized (repaintManager2) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        RepaintManager repaintManager = this.getDelegate(jComponent);
        if (repaintManager != null) {
            return repaintManager.isCompletelyDirty(jComponent);
        }
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        List<Component> list;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                return;
            }
            list = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            final Component component = list.get(i);
            AccessControlContext accessControlContext = AccessController.getContext();
            AccessControlContext accessControlContext2 = AWTAccessor.getComponentAccessor().getAccessControlContext(component);
            javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    component.validate();
                    return null;
                }
            }, accessControlContext, accessControlContext2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prePaintDirtyRegions() {
        List<Runnable> list;
        Map<Component, Rectangle> map;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            map = this.dirtyComponents;
            list = this.runnableList;
            this.runnableList = null;
        }
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
        this.paintDirtyRegions();
        if (map.size() > 0) {
            this.paintDirtyRegions(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            Map<Component, Rectangle> map = this.tmpDirtyComponents;
            this.tmpDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = map;
            this.dirtyComponents.clear();
        }
        this.paintDirtyRegions(this.tmpDirtyComponents);
    }

    private void updateWindows(Map<Component, Rectangle> map) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(AWTUtilities.isTranslucencySupported(AWTUtilities.Translucency.PERPIXEL_TRANSLUCENT) && toolkit instanceof SunToolkit && ((SunToolkit)toolkit).needUpdateWindow())) {
            return;
        }
        HashSet<Window> hashSet = new HashSet<Window>();
        Set<Component> set = map.keySet();
        for (Component component : set) {
            Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window == null || AWTAccessor.getWindowAccessor().isOpaque(window)) continue;
            hashSet.add(window);
        }
        for (Window window : hashSet) {
            AWTAccessor.getWindowAccessor().updateWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDirtyRegions(final Map<Component, Rectangle> map) {
        if (map.isEmpty()) {
            return;
        }
        final ArrayList<Component> arrayList = new ArrayList<Component>(map.size());
        for (Component component : map.keySet()) {
            this.collectDirtyComponents(map, component, arrayList);
        }
        final AtomicInteger atomicInteger = new AtomicInteger(arrayList.size());
        this.painting = true;
        try {
            for (int i = 0; i < atomicInteger.get(); ++i) {
                final int n = i;
                final Component component = (Component)arrayList.get(i);
                AccessControlContext accessControlContext = AccessController.getContext();
                AccessControlContext accessControlContext2 = AWTAccessor.getComponentAccessor().getAccessControlContext(component);
                javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void run() {
                        Graphics graphics;
                        Rectangle rectangle = (Rectangle)map.get(component);
                        int n3 = component.getHeight();
                        int n2 = component.getWidth();
                        SwingUtilities.computeIntersection(0, 0, n2, n3, rectangle);
                        if (component instanceof JComponent) {
                            ((JComponent)component).paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        } else if (component.isShowing() && (graphics = JComponent.safelyGetGraphics(component, component)) != null) {
                            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            try {
                                component.paint(graphics);
                            }
                            finally {
                                graphics.dispose();
                            }
                        }
                        if (RepaintManager.this.repaintRoot != null) {
                            RepaintManager.this.adjustRoots(RepaintManager.this.repaintRoot, arrayList, n + 1);
                            atomicInteger.set(arrayList.size());
                            ((RepaintManager)RepaintManager.this).paintManager.isRepaintingRoot = true;
                            RepaintManager.this.repaintRoot.paintImmediately(0, 0, RepaintManager.this.repaintRoot.getWidth(), RepaintManager.this.repaintRoot.getHeight());
                            ((RepaintManager)RepaintManager.this).paintManager.isRepaintingRoot = false;
                            RepaintManager.this.repaintRoot = null;
                        }
                        return null;
                    }
                }, accessControlContext, accessControlContext2);
            }
        }
        finally {
            this.painting = false;
        }
        this.updateWindows(map);
        map.clear();
    }

    boolean isPainting() {
        return this.painting;
    }

    private void adjustRoots(JComponent jComponent, List<Component> list, int n) {
        for (int i = list.size() - 1; i >= n; --i) {
            Component component;
            for (component = list.get(i); component != jComponent && component != null && component instanceof JComponent; component = component.getParent()) {
            }
            if (component != jComponent) continue;
            list.remove(i);
        }
    }

    void collectDirtyComponents(Map<Component, Rectangle> map, Component component, List<Component> list) {
        Container container;
        Component component2;
        Component component3 = component2 = component;
        int n = component.getX();
        int n2 = component.getY();
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        this.tmp.setBounds(map.get(component));
        SwingUtilities.computeIntersection(0, 0, n3, n4, this.tmp);
        if (this.tmp.isEmpty()) {
            return;
        }
        while (component3 instanceof JComponent && (container = component3.getParent()) != null) {
            component3 = container;
            n6 += n;
            n8 += n2;
            this.tmp.setLocation(this.tmp.x + n, this.tmp.y + n2);
            n = component3.getX();
            n2 = component3.getY();
            n3 = component3.getWidth();
            n4 = component3.getHeight();
            this.tmp = SwingUtilities.computeIntersection(0, 0, n3, n4, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            if (map.get(component3) == null) continue;
            component2 = component3;
            n5 = n6;
            n7 = n8;
        }
        if (component != component2) {
            this.tmp.setLocation(this.tmp.x + n5 - n6, this.tmp.y + n7 - n8);
            Rectangle rectangle = map.get(component2);
            SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, rectangle);
        }
        if (!list.contains(component2)) {
            list.add(component2);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append("" + this.dirtyComponents);
        }
        return stringBuffer.toString();
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        RepaintManager repaintManager = this.getDelegate(component);
        if (repaintManager != null) {
            return repaintManager.getOffscreenBuffer(component, n, n2);
        }
        return this._getOffscreenBuffer(component, n, n2);
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        Object object;
        Window window;
        RepaintManager repaintManager = this.getDelegate(component);
        if (repaintManager != null) {
            return repaintManager.getVolatileOffscreenBuffer(component, n, n2);
        }
        Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (!AWTAccessor.getWindowAccessor().isOpaque(window) && (object = Toolkit.getDefaultToolkit()) instanceof SunToolkit && ((SunToolkit)object).needUpdateWindow()) {
            return null;
        }
        object = component.getGraphicsConfiguration();
        if (object == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Dimension dimension = this.getDoubleBufferMaximumSize();
        int n4 = n < 1 ? 1 : (n3 = n > dimension.width ? dimension.width : n);
        int n5 = n2 < 1 ? 1 : (n2 > dimension.height ? dimension.height : n2);
        VolatileImage volatileImage = this.volatileMap.get(object);
        if (volatileImage == null || volatileImage.getWidth() < n3 || volatileImage.getHeight() < n5) {
            if (volatileImage != null) {
                volatileImage.flush();
            }
            volatileImage = ((GraphicsConfiguration)object).createCompatibleVolatileImage(n3, n5);
            this.volatileMap.put((GraphicsConfiguration)object, volatileImage);
        }
        return volatileImage;
    }

    private Image _getOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        int n4;
        Object object;
        Window window;
        Dimension dimension = this.getDoubleBufferMaximumSize();
        DoubleBufferInfo doubleBufferInfo = null;
        Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (!AWTAccessor.getWindowAccessor().isOpaque(window) && (object = Toolkit.getDefaultToolkit()) instanceof SunToolkit && ((SunToolkit)object).needUpdateWindow()) {
            return null;
        }
        if (this.standardDoubleBuffer == null) {
            this.standardDoubleBuffer = new DoubleBufferInfo();
        }
        doubleBufferInfo = this.standardDoubleBuffer;
        int n5 = n < 1 ? 1 : (n4 = n > dimension.width ? dimension.width : n);
        int n6 = n2 < 1 ? 1 : (n3 = n2 > dimension.height ? dimension.height : n2);
        if (doubleBufferInfo.needsReset || doubleBufferInfo.image != null && (doubleBufferInfo.size.width < n4 || doubleBufferInfo.size.height < n3)) {
            doubleBufferInfo.needsReset = false;
            if (doubleBufferInfo.image != null) {
                doubleBufferInfo.image.flush();
                doubleBufferInfo.image = null;
            }
            n4 = Math.max(doubleBufferInfo.size.width, n4);
            n3 = Math.max(doubleBufferInfo.size.height, n3);
        }
        object = doubleBufferInfo.image;
        if (doubleBufferInfo.image == null) {
            object = component.createImage(n4, n3);
            doubleBufferInfo.size = new Dimension(n4, n3);
            if (component instanceof JComponent) {
                ((JComponent)component).setCreatedDoubleBuffer(true);
                doubleBufferInfo.image = object;
            }
        }
        return object;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.doubleBufferMaxSize == null) {
            this.clearImages();
        } else {
            this.clearImages(dimension.width, dimension.height);
        }
    }

    private void clearImages() {
        this.clearImages(0, 0);
    }

    private void clearImages(int n, int n2) {
        if (this.standardDoubleBuffer != null && this.standardDoubleBuffer.image != null && (this.standardDoubleBuffer.image.getWidth(null) > n || this.standardDoubleBuffer.image.getHeight(null) > n2)) {
            this.standardDoubleBuffer.image.flush();
            this.standardDoubleBuffer.image = null;
        }
        Iterator<GraphicsConfiguration> iterator = this.volatileMap.keySet().iterator();
        while (iterator.hasNext()) {
            GraphicsConfiguration graphicsConfiguration = iterator.next();
            VolatileImage volatileImage = this.volatileMap.get(graphicsConfiguration);
            if (volatileImage.getWidth() <= n && volatileImage.getHeight() <= n2) continue;
            volatileImage.flush();
            iterator.remove();
        }
    }

    public Dimension getDoubleBufferMaximumSize() {
        if (this.doubleBufferMaxSize == null) {
            try {
                Rectangle rectangle = new Rectangle();
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                    GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
                this.doubleBufferMaxSize = new Dimension(rectangle.width, rectangle.height);
            }
            catch (HeadlessException headlessException) {
                this.doubleBufferMaxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        }
        return this.doubleBufferMaxSize;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
        PaintManager paintManager = this.getPaintManager();
        if (!bl && paintManager.getClass() != PaintManager.class) {
            this.setPaintManager(new PaintManager());
        }
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    void resetDoubleBuffer() {
        if (this.standardDoubleBuffer != null) {
            this.standardDoubleBuffer.needsReset = true;
        }
    }

    void resetVolatileDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        Image image = this.volatileMap.remove(graphicsConfiguration);
        if (image != null) {
            image.flush();
        }
    }

    boolean useVolatileDoubleBuffer() {
        return volatileImageBufferEnabled;
    }

    private synchronized boolean isPaintingThread() {
        return Thread.currentThread() == this.paintThread;
    }

    void paint(JComponent jComponent, JComponent jComponent2, Graphics graphics, int n, int n2, int n3, int n4) {
        PaintManager paintManager = this.getPaintManager();
        if (!this.isPaintingThread() && paintManager.getClass() != PaintManager.class) {
            paintManager = new PaintManager();
            paintManager.repaintManager = this;
        }
        if (!paintManager.paint(jComponent, jComponent2, graphics, n, n2, n3, n4)) {
            graphics.setClip(n, n2, n3, n4);
            jComponent.paintToOffscreen(graphics, n, n2, n3, n4, n + n3, n2 + n4);
        }
    }

    void copyArea(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.getPaintManager().copyArea(jComponent, graphics, n, n2, n3, n4, n5, n6, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginPaint() {
        boolean bl = false;
        int n = 0;
        Thread thread = Thread.currentThread();
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            n = this.paintDepth;
            if (this.paintThread == null || thread == this.paintThread) {
                this.paintThread = thread;
                ++this.paintDepth;
            } else {
                bl = true;
            }
        }
        if (!bl && n == 0) {
            this.getPaintManager().beginPaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endPaint() {
        if (this.isPaintingThread()) {
            PaintManager paintManager = null;
            RepaintManager repaintManager = this;
            synchronized (repaintManager) {
                if (--this.paintDepth == 0) {
                    paintManager = this.getPaintManager();
                }
            }
            if (paintManager != null) {
                paintManager.endPaint();
                repaintManager = this;
                synchronized (repaintManager) {
                    this.paintThread = null;
                }
            }
        }
    }

    boolean show(Container container, int n, int n2, int n3, int n4) {
        return this.getPaintManager().show(container, n, n2, n3, n4);
    }

    void doubleBufferingChanged(JRootPane jRootPane) {
        this.getPaintManager().doubleBufferingChanged(jRootPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPaintManager(PaintManager paintManager) {
        PaintManager paintManager2;
        if (paintManager == null) {
            paintManager = new PaintManager();
        }
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            paintManager2 = this.paintManager;
            this.paintManager = paintManager;
            paintManager.repaintManager = this;
        }
        if (paintManager2 != null) {
            paintManager2.dispose();
        }
    }

    private synchronized PaintManager getPaintManager() {
        if (this.paintManager == null) {
            BufferStrategyPaintManager bufferStrategyPaintManager = null;
            if (this.doubleBufferingEnabled && !nativeDoubleBuffering) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                switch (this.bufferStrategyType) {
                    case 0: {
                        if (!(toolkit instanceof SunToolkit) || !((SunToolkit)toolkit).useBufferPerWindow()) break;
                        bufferStrategyPaintManager = new BufferStrategyPaintManager();
                        break;
                    }
                    case 1: {
                        bufferStrategyPaintManager = new BufferStrategyPaintManager();
                        break;
                    }
                }
            }
            this.setPaintManager(bufferStrategyPaintManager);
        }
        return this.paintManager;
    }

    private void scheduleProcessingRunnable() {
        this.scheduleProcessingRunnable(AppContext.getAppContext());
    }

    private void scheduleProcessingRunnable(AppContext appContext) {
        if (this.processingRunnable.markPending()) {
            SunToolkit.getSystemEventQueueImplPP(appContext).postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), this.processingRunnable));
        }
    }

    private RepaintManager getDelegate(Component component) {
        RepaintManager repaintManager = SwingUtilities3.getDelegateRepaintManager(component);
        if (this == repaintManager) {
            repaintManager = null;
        }
        return repaintManager;
    }

    static {
        repaintManagerKey = RepaintManager.class;
        volatileImageBufferEnabled = true;
        volatileImageBufferEnabled = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.volatileImageBufferEnabled", "true")));
        boolean bl = GraphicsEnvironment.isHeadless();
        if (volatileImageBufferEnabled && bl) {
            volatileImageBufferEnabled = false;
        }
        nativeDoubleBuffering = "true".equals(AccessController.doPrivileged(new GetPropertyAction("awt.nativeDoubleBuffering")));
        String string = AccessController.doPrivileged(new GetPropertyAction("swing.bufferPerWindow"));
        BUFFER_STRATEGY_TYPE = bl ? (short)2 : (string == null ? (short)0 : ("true".equals(string) ? (short)1 : (short)2));
        HANDLE_TOP_LEVEL_PAINT = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.handleTopLevelPaint", "true")));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof SunGraphicsEnvironment) {
            ((SunGraphicsEnvironment)graphicsEnvironment).addDisplayChangedListener(new DisplayChangedHandler());
        }
        javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
    }

    private static final class DisplayChangedHandler
    implements DisplayChangedListener {
        private DisplayChangedHandler() {
        }

        public void displayChanged() {
            this.scheduleDisplayChanges();
        }

        public void paletteChanged() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleDisplayChanges() {
            Iterator<AppContext> iterator = AppContext.getAppContexts().iterator();
            while (iterator.hasNext()) {
                AppContext appContext;
                AppContext appContext2;
                AppContext appContext3 = appContext2 = (appContext = iterator.next());
                synchronized (appContext3) {
                    EventQueue eventQueue;
                    if (!appContext2.isDisposed() && (eventQueue = (EventQueue)appContext2.get(AppContext.EVENT_QUEUE_KEY)) != null) {
                        eventQueue.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new DisplayChangedRunnable()));
                    }
                }
            }
        }
    }

    private static final class DisplayChangedRunnable
    implements Runnable {
        private DisplayChangedRunnable() {
        }

        public void run() {
            RepaintManager.currentManager((JComponent)null).displayChanged();
        }
    }

    private class DoubleBufferInfo {
        public Image image;
        public Dimension size;
        public boolean needsReset = false;

        private DoubleBufferInfo() {
        }
    }

    static class PaintManager {
        protected RepaintManager repaintManager;
        boolean isRepaintingRoot;

        PaintManager() {
        }

        public boolean paint(JComponent jComponent, JComponent jComponent2, Graphics graphics, int n, int n2, int n3, int n4) {
            Image image;
            boolean bl = false;
            if (this.repaintManager.useVolatileDoubleBuffer() && (image = this.getValidImage(this.repaintManager.getVolatileOffscreenBuffer(jComponent2, n3, n4))) != null) {
                VolatileImage volatileImage = (VolatileImage)image;
                GraphicsConfiguration graphicsConfiguration = jComponent2.getGraphicsConfiguration();
                for (int i = 0; !bl && i < 2; ++i) {
                    if (volatileImage.validate(graphicsConfiguration) == 2) {
                        this.repaintManager.resetVolatileDoubleBuffer(graphicsConfiguration);
                        image = this.repaintManager.getVolatileOffscreenBuffer(jComponent2, n3, n4);
                        volatileImage = (VolatileImage)image;
                    }
                    this.paintDoubleBuffered(jComponent, volatileImage, graphics, n, n2, n3, n4);
                    bl = !volatileImage.contentsLost();
                }
            }
            if (!bl && (image = this.getValidImage(this.repaintManager.getOffscreenBuffer(jComponent2, n3, n4))) != null) {
                this.paintDoubleBuffered(jComponent, image, graphics, n, n2, n3, n4);
                bl = true;
            }
            return bl;
        }

        public void copyArea(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            graphics.copyArea(n, n2, n3, n4, n5, n6);
        }

        public void beginPaint() {
        }

        public void endPaint() {
        }

        public boolean show(Container container, int n, int n2, int n3, int n4) {
            return false;
        }

        public void doubleBufferingChanged(JRootPane jRootPane) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintDoubleBuffered(JComponent jComponent, Image image, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics graphics2 = image.getGraphics();
            int n5 = Math.min(n3, image.getWidth(null));
            int n6 = Math.min(n4, image.getHeight(null));
            try {
                int n7 = n + n3;
                for (int i = n; i < n7; i += n5) {
                    int n8 = n2 + n4;
                    for (int j = n2; j < n8; j += n6) {
                        graphics2.translate(-i, -j);
                        graphics2.setClip(i, j, n5, n6);
                        jComponent.paintToOffscreen(graphics2, i, j, n5, n6, n7, n8);
                        graphics.setClip(i, j, n5, n6);
                        graphics.drawImage(image, i, j, jComponent);
                        graphics2.translate(i, j);
                    }
                }
            }
            finally {
                graphics2.dispose();
            }
        }

        private Image getValidImage(Image image) {
            if (image != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
                return image;
            }
            return null;
        }

        protected void repaintRoot(JComponent jComponent) {
            assert (this.repaintManager.repaintRoot == null);
            if (this.repaintManager.painting) {
                this.repaintManager.repaintRoot = jComponent;
            } else {
                jComponent.repaint();
            }
        }

        protected boolean isRepaintingRoot() {
            return this.isRepaintingRoot;
        }

        protected void dispose() {
        }
    }

    private final class ProcessingRunnable
    implements Runnable {
        private boolean pending;

        private ProcessingRunnable() {
        }

        public synchronized boolean markPending() {
            if (!this.pending) {
                this.pending = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProcessingRunnable processingRunnable = this;
            synchronized (processingRunnable) {
                this.pending = false;
            }
            RepaintManager.this.scheduleHeavyWeightPaints();
            RepaintManager.this.validateInvalidComponents();
            RepaintManager.this.prePaintDirtyRegions();
        }
    }
}

