/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.Inet4AddressImpl;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetAddressImpl;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

class Inet6AddressImpl
implements InetAddressImpl {
    private InetAddress anyLocalAddress;
    private InetAddress loopbackAddress;

    Inet6AddressImpl() {
    }

    public native String getLocalHostName() throws UnknownHostException;

    public native InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    public native String getHostByAddr(byte[] var1) throws UnknownHostException;

    private native boolean isReachable0(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws IOException;

    public boolean isReachable(InetAddress inetAddress, int n, NetworkInterface networkInterface, int n2) throws IOException {
        byte[] byArray = null;
        int n3 = -1;
        int n4 = -1;
        if (networkInterface != null) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            InetAddress inetAddress2 = null;
            while (enumeration.hasMoreElements()) {
                inetAddress2 = enumeration.nextElement();
                if (!inetAddress2.getClass().isInstance(inetAddress)) continue;
                byArray = inetAddress2.getAddress();
                if (!(inetAddress2 instanceof Inet6Address)) break;
                n4 = ((Inet6Address)inetAddress2).getScopeId();
                break;
            }
            if (byArray == null) {
                return false;
            }
        }
        if (inetAddress instanceof Inet6Address) {
            n3 = ((Inet6Address)inetAddress).getScopeId();
        }
        return this.isReachable0(inetAddress.getAddress(), n3, n, byArray, n2, n4);
    }

    public synchronized InetAddress anyLocalAddress() {
        if (this.anyLocalAddress == null) {
            if (InetAddress.preferIPv6Address) {
                this.anyLocalAddress = new Inet6Address();
                this.anyLocalAddress.holder().hostName = "::";
            } else {
                this.anyLocalAddress = new Inet4AddressImpl().anyLocalAddress();
            }
        }
        return this.anyLocalAddress;
    }

    public synchronized InetAddress loopbackAddress() {
        if (this.loopbackAddress == null) {
            if (InetAddress.preferIPv6Address) {
                byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
                this.loopbackAddress = new Inet6Address("localhost", byArray);
            } else {
                this.loopbackAddress = new Inet4AddressImpl().loopbackAddress();
            }
        }
        return this.loopbackAddress;
    }
}

