/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.StringQuoteUtil;
import java.util.Properties;

public class Property
implements Cloneable {
    private static final boolean DEBUG = false;
    String key;
    String value;
    boolean isSecure;
    private static final boolean _quoteWholePropertySpec = Config.getOSName().startsWith("Win");

    public Property(String string) {
        string = StringQuoteUtil.unquoteIfNeeded(string);
        int n = string.indexOf("-D");
        if (n < 0 || n == string.length() - 2) {
            throw new IllegalArgumentException("Property invalid");
        }
        n += 2;
        int n2 = string.indexOf("=");
        if (n2 < 0) {
            this.key = string.substring(n);
            this.value = new String("");
        } else {
            this.key = string.substring(n, n2);
            this.value = StringQuoteUtil.unquoteIfNeeded(string.substring(n2 + 1));
        }
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public static Property createProperty(String string) {
        Property property = null;
        try {
            property = new Property(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return property;
    }

    public Property(String string, String string2) {
        this.key = string;
        this.value = string2 != null ? StringQuoteUtil.unquoteIfNeeded(string2) : new String("");
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        if (this.value.length() == 0) {
            return "-D" + this.key;
        }
        if (bl && _quoteWholePropertySpec) {
            return StringQuoteUtil.quoteIfNeeded("-D" + this.key + "=" + this.value);
        }
        return "-D" + this.key + "=" + StringQuoteUtil.quoteIfNeeded(this.value);
    }

    public void addTo(Properties properties) {
        properties.setProperty(this.key, this.value);
    }

    public Object clone() {
        return new Property(this.key, this.value);
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        int n2 = property.hashCode();
        return n2 == (n = this.hashCode());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static final boolean getQuotesWholePropertySpec() {
        return _quoteWholePropertySpec;
    }
}

